package cn.smarthse.modules.health.entity.work.assign.push;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * @ClassName PushResult
 * @Description 推送结果反馈
 * @Author 曾华川
 * @Date 2024年03月21日 17:32
 **/
@Data
public class PushResult implements Serializable {

    private static final long serialVersionUID = 5223232292443621166L;
    private String uniqueId;

    /**
     * 处理时间
     */
    private Date dealTime;

    /**
     * 整改状态（1-处理中，2-已完成，3-无需处理，4-已解除）
     */
    private Integer status;

    /**
     * 本次处理部门
     */
    private String dealDeptName;

    /**
     * 本次处理人员
     */
    private String dealWorker;

    /**
     * 处理结果
     */
    private String dealResult;

}
