package cn.smarthse.modules.health.entity.work.assign.push;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnore;
import lombok.Data;

import javax.persistence.Id;
import javax.persistence.Table;
import javax.persistence.Transient;
import java.io.Serializable;
import java.util.Date;

/**
 * @ClassName ChuangdePushRiskData
 * @Description 风险推送实体
 * @Author 曾华川
 * @Date 2024年03月13日 10:00
 **/
@Table(name = "chuangde_push_risk_data")
@Data
public class ChuangdePushRiskData implements Serializable {

    private static final long serialVersionUID = 6792313902855573933L;
    @Id
    private Long id;

    /**
     * 个性化系统ID
     */
    private String systemId;

    /**
     * 风险规则ID
     */
    private String ruleId;

    /**
     * 风险唯一标识：各个系统生成的唯一ID，以方便反馈及结果查询
     * 唯一 ID 生成规则：风险系统 ID + 风险规则 ID+标识字符串
     * 当风险唯一标识已存在时，更新这条风险线索，解除风险或已成功上报互联网+的数据不允许更新或删除
     */
    private String uniqueId;

    /**
     * 企业id
     */
    @JsonIgnore
    private Long companyId;

    /**
     * 企业名称
     */
    // @JsonIgnore
    private String companyName;

    /**
     * 风险识别日期
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss",timezone = "GMT+8")
    private Date riskDate;

    /**
     * 统一社会信用代码，当监管主体类型为企业时必填
     */
    private String creditCode;

    /**
     * 风险发生的地点
     */
    private String riskLocation;

    /**
     * 风险主体所在地行政区划，如330000，精确到区县
     */
    private String riskArea;

    /**
     * 风险主体唯一标识
     */
    private String riskMainpartId;

    /**
     * 风险主体名称
     */
    private String riskMainpartName;

    /**
     * 风险标题
     */
    private String riskTitle;

    /**
     * 风险内容
     */
    private String riskContent;

    /**
     * 预警来源，如网络举报
     */
    private String riskResource;

    /**
     * 可访问的 url 地址，作为风险线索的相关辅助材料
     */
    private String fileUrl;

    /**
     *   处理风险预警信息单位的区域代码
     */
    private String regionCode;

    /**
     * 处理风险预警信息单位的机构编码
     */
    private String orgcode;

    /**
     *   指定处置截止时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd")
    private Date handleDate;

    /**
     * 处置人员手机号
     */
    private String handlePersonPhone;

    /**
     * 电子固证信息 URL，字符串数组，最多传 100 个
     */
    private String solidUrls;
    @JsonIgnore
    private String urls;

    /**
     * 删除标识: 当 isDelete=1 时，删除已存在库中风险，
     *          当 isDelete=0 或不传时，新增或更新风险唯一标识对应风险线索记录
     */
    private Integer isDelete = 0;

    /**
     * 监管主体类型：1.无主体 2.企业 3.自然人
     */
    private Integer objectType;

    /**
     *  自然人身份证号码，当监管主体类型为 自然人时必填
     */
    private String idCard;

    /**
     * 记录相同企业风险的个数
     */
    @JsonIgnore
    @Transient
    private Integer count = 1;

    /**
     * 推送失败原因
     */
    // @JsonIgnore
    private String errorMessage;

    /**
     * 生成的风险类型
     */
    @JsonIgnore
    private String generationSource;

    /**
     * 企业当时的区域id
     */
    @JsonIgnore
    private Long companyAreaId;

    @JsonIgnore
    //0未处理， 1处理中， 2 已处理， 3推送失败
    private Integer isProc;

    @JsonIgnore
    //1新增数据， 0表示数据有修改 推送时需要
    private Boolean isAdd;

    @JsonIgnore
    //是否需要推送， 新增和修改后都需要重置为1 表示需要推送
    private Integer needPull;

    @JsonIgnore
    //最后推送时间
    private Date lastPullDate;

    @JsonIgnore
    //创建时间
    private Date createDate;

    @JsonIgnore
    //创建人
    private Long createBy;

    @JsonIgnore
    //最后修改时间
    private Date updateDate;

    @JsonIgnore
    //最后修改人ID
    private Long updateBy;

    @JsonIgnore
    //是否有效（0-无效，1-有效）
    private Boolean isValid;

    @JsonIgnore
    // 数据源ID
    private String sourceId;

    @JsonIgnore
    //推送次数（超过三次停止推送）
    private int pushNum;
}
