package cn.smarthse.modules.health.entity.work.assign.param;

import lombok.Data;

import java.io.Serializable;

/**
 * @ClassName RiskAssignSearch
 * @Description 交办/通报风险列表查询参数
 * @Author 曾华川
 * @Date 2024年03月07日 14:02
 **/
@Data
public class RiskAssignSearch implements Serializable {

    private static final long serialVersionUID = 3426397736624771036L;
    private Long areaId;
    private Byte areaLevel;

    private Long workId;

    /**
     * 风险推送状态
     */
    private Integer pushStatus;

    /**
     * 整改状态（1-处理中，2-已完成，3-无需处理）
     */
    private Integer status;

    private String keyWord;

    private String cids;

    private Boolean exportAll;

    /**
     * 风险类型（1-低风险，2-高风险）
     */
    private Integer type;
}
