package cn.smarthse.modules.health.entity.work.assign;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.persistence.Id;
import javax.persistence.Table;
import java.io.Serializable;
import java.util.Date;

/**
 * 交办/通报风险表
 * @TableName risk_assign
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@Table(name = "risk_assign")
public class RiskAssign implements Serializable {

    private static final long serialVersionUID = -6954662424510645546L;
    /**
     * 主键id
     */
    @Id
    private Long id;

    /**
     * 工作id
     */
    private Long workId;

    /**
     * 企业id
     */
    private Long cid;

    /**
     * 企业名称
     */
    private String companyName;

    /**
     * 统一社会信用代码
     */
    private String unifiedSocialCc;

    /**
     * 行政区划id（省市区街道），市级id，区县id
     */
    private Long areaDetailId;
    private Long cityId;
    private Long areaId;

    /**
     * 监督单位id
     */
    private Long supervisionUnit;

    /**
     * 标题
     */
    private String title;

    /**
     * 风险类型（1-低风险，2-高风险）
     */
    private Integer type;

    /**
     * 预警内容
     */
    private String warningContent;

    /**
     * 文件id
     */
    private String fileId;
    private String fileName;

    /**
     * 风险推送状态（0-未推送，1-已推送）
     */
    private Integer pushStatus;

    /**
     * 推送时间（预警时间）
     */
    private Date pushTime;

    /**
     * 处理时间
     */
    private Date dealTime;

    /**
     * 整改状态（1-处理中，2-已完成，3-无需处理）
     */
    private Integer status;

    /**
     * 本次处理部门
     */
    private String dealDeptName;

    /**
     * 本次处理人员
     */
    private String dealWorker;

    /**
     * 处理结果
     */
    private String dealResult;

    /**
     * 是否有效（0-无效，1-有效）
     */
    private Boolean isValid;

    /**
     * 创建人
     */
    private Long createBy;

    /**
     * 创建时间
     */
    private Date createDate;

    /**
     * 最后修改人ID
     */
    private Long updateBy;

    /**
     * 最后修改时间
     */
    private Date updateDate;
}