package cn.smarthse.modules.health.entity.work.accident;

import java.io.Serializable;
import javax.persistence.*;

@Table(name = "eme_accident_files")
public class EmeAccidentFiles implements Serializable {
    /**
     * ID
     */
    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY, generator = "select RIGHT(uuid_short(), 19)")
    private Long id;

    /**
     * 企业ID
     */
    private Long cid;

    /**
     * 事故ID
     */
    @Column(name = "accident_id")
    private Long accidentId;

    /**
     * 附件id(File.ID)
     */
    @Column(name = "file_id")
    private Long fileId;

    /**
     * 附件名称
     */
    @Column(name = "file_name")
    private String fileName;

    /**
     * 附件路径
     */
    @Column(name = "file_url")
    private String fileUrl;

    /**
     * 附件类型(1-现场照片,2-报告和处理记录,3-其他附件)
            
     */
    @Column(name = "file_type")
    private Byte fileType;

    private static final long serialVersionUID = 1L;

    /**
     * 获取ID
     *
     * @return id - ID
     */
    public Long getId() {
        return id;
    }

    /**
     * 设置ID
     *
     * @param id ID
     */
    public void setId(Long id) {
        this.id = id;
    }

    /**
     * 获取企业ID
     *
     * @return cid - 企业ID
     */
    public Long getCid() {
        return cid;
    }

    /**
     * 设置企业ID
     *
     * @param cid 企业ID
     */
    public void setCid(Long cid) {
        this.cid = cid;
    }

    /**
     * 获取事故ID
     *
     * @return accident_id - 事故ID
     */
    public Long getAccidentId() {
        return accidentId;
    }

    /**
     * 设置事故ID
     *
     * @param accidentId 事故ID
     */
    public void setAccidentId(Long accidentId) {
        this.accidentId = accidentId;
    }

    /**
     * 获取附件id(File.ID)
     *
     * @return file_id - 附件id(File.ID)
     */
    public Long getFileId() {
        return fileId;
    }

    /**
     * 设置附件id(File.ID)
     *
     * @param fileId 附件id(File.ID)
     */
    public void setFileId(Long fileId) {
        this.fileId = fileId;
    }

    /**
     * 获取附件名称
     *
     * @return file_name - 附件名称
     */
    public String getFileName() {
        return fileName;
    }

    /**
     * 设置附件名称
     *
     * @param fileName 附件名称
     */
    public void setFileName(String fileName) {
        this.fileName = fileName == null ? null : fileName.trim();
    }

    /**
     * 获取附件路径
     *
     * @return file_url - 附件路径
     */
    public String getFileUrl() {
        return fileUrl;
    }

    /**
     * 设置附件路径
     *
     * @param fileUrl 附件路径
     */
    public void setFileUrl(String fileUrl) {
        this.fileUrl = fileUrl == null ? null : fileUrl.trim();
    }

    /**
     * 获取附件类型(1-现场照片,2-报告和处理记录,3-其他附件)
            
     *
     * @return file_type - 附件类型(1-现场照片,2-报告和处理记录,3-其他附件)
            
     */
    public Byte getFileType() {
        return fileType;
    }

    /**
     * 设置附件类型(1-现场照片,2-报告和处理记录,3-其他附件)
            
     *
     * @param fileType 附件类型(1-现场照片,2-报告和处理记录,3-其他附件)
            
     */
    public void setFileType(Byte fileType) {
        this.fileType = fileType;
    }
}