package cn.smarthse.modules.health.entity.work.accident;

import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import javax.persistence.Column;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.persistence.Transient;

@Table(name = "eme_accident")
public class EmeAccident implements Serializable {
    /**
     * ID
     */
    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY, generator = "select RIGHT(uuid_short(), 19)")
    private Long id;

    /**
     * 企业ID
     */
    private Long cid;

    /**
     * 事故编号
     */
    private String no;

    /**
     * 事故名称
     */
    private String name;

    /**
     * 发生时间
     */
    @Column(name = "happen_time")
    private Date happenTime;
    
    @Transient
    private String happenTimeStr;

    /**
     * 事故等级（1、一般事故 2、较大事故 3、重大事故 4、特别重大事故）
     */
    private String level;
    
    @Transient
    private String levelName;

    /**
     * 相关纸质档案存放位置
     */
    @Column(name = "store_location")
    private String storeLocation;

    /**
     * 归档负责人
     */
    @Column(name = "store_manger_id")
    private Integer storeMangerId;

    /**
     * 备注
     */
    private String remark;

    /**
     * 状态（0、未完成 1、已完成）
     */
    private Byte status;

    /**
     * 创建人
     */
    @Column(name = "create_by")
    private Long createBy;
    
    @Transient
    private String createByName;

    /**
     * 创建时间
     */
    @Column(name = "create_date")
    private Date createDate;

    /**
     * 最后修改人ID
     */
    @Column(name = "update_by")
    private Long updateBy;

    /**
     * 最后修改时间
     */
    @Column(name = "update_date")
    private Date updateDate;
    
    /**
     * 现场照片
     */
    @Transient
    private List<EmeAccidentFiles> photos = new ArrayList<EmeAccidentFiles>();
    /**
     * 报告和处理记录
     */
    @Transient
    private List<EmeAccidentFiles> reports = new ArrayList<EmeAccidentFiles>();
    /**
     * 其他附件
     */
    @Transient
    private List<EmeAccidentFiles> others = new ArrayList<EmeAccidentFiles>();
    
    @Transient
    private Date beginTime;
	
    @Transient
	private Date endTime;

    /**
     * 是否有效（0-无效，1-有效）
     */
    @Column(name = "is_valid")
    private Boolean isValid;

    /**
     * 创建人对应的部门
     */
    @Column(name = "org_id")
    private String orgId;

    private static final long serialVersionUID = 1L;

    /**
     * 获取ID
     *
     * @return id - ID
     */
    public Long getId() {
        return id;
    }

    /**
     * 设置ID
     *
     * @param id ID
     */
    public void setId(Long id) {
        this.id = id;
    }

    /**
     * 获取企业ID
     *
     * @return cid - 企业ID
     */
    public Long getCid() {
        return cid;
    }

    /**
     * 设置企业ID
     *
     * @param cid 企业ID
     */
    public void setCid(Long cid) {
        this.cid = cid;
    }

    /**
     * 获取事故编号
     *
     * @return no - 事故编号
     */
    public String getNo() {
        return no;
    }

    /**
     * 设置事故编号
     *
     * @param no 事故编号
     */
    public void setNo(String no) {
        this.no = no == null ? null : no.trim();
    }

    /**
     * 获取事故名称
     *
     * @return name - 事故名称
     */
    public String getName() {
        return name;
    }

    /**
     * 设置事故名称
     *
     * @param name 事故名称
     */
    public void setName(String name) {
        this.name = name == null ? null : name.trim();
    }

    /**
     * 获取发生时间
     *
     * @return happen_time - 发生时间
     */
    public Date getHappenTime() {
        return happenTime;
    }

    /**
     * 设置发生时间
     *
     * @param happenTime 发生时间
     */
    public void setHappenTime(Date happenTime) {
        this.happenTime = happenTime;
    }

    /**
     * 获取事故等级（1、一般事故 2、较大事故 3、重大事故 4、特别重大事故）
     *
     * @return level - 事故等级（1、一般事故 2、较大事故 3、重大事故 4、特别重大事故）
     */
    public String getLevel() {
        return level;
    }

    /**
     * 设置事故等级（1、一般事故 2、较大事故 3、重大事故 4、特别重大事故）
     *
     * @param level 事故等级（1、一般事故 2、较大事故 3、重大事故 4、特别重大事故）
     */
    public void setLevel(String level) {
        this.level = level;
    }

    /**
     * 获取相关纸质档案存放位置
     *
     * @return store_location - 相关纸质档案存放位置
     */
    public String getStoreLocation() {
        return storeLocation;
    }

    /**
     * 设置相关纸质档案存放位置
     *
     * @param storeLocation 相关纸质档案存放位置
     */
    public void setStoreLocation(String storeLocation) {
        this.storeLocation = storeLocation == null ? null : storeLocation.trim();
    }

    /**
     * 获取归档负责人
     *
     * @return store_manger_id - 归档负责人
     */
    public Integer getStoreMangerId() {
        return storeMangerId;
    }

    /**
     * 设置归档负责人
     *
     * @param storeMangerId 归档负责人
     */
    public void setStoreMangerId(Integer storeMangerId) {
        this.storeMangerId = storeMangerId;
    }

    /**
     * 获取备注
     *
     * @return remark - 备注
     */
    public String getRemark() {
        return remark;
    }

    /**
     * 设置备注
     *
     * @param remark 备注
     */
    public void setRemark(String remark) {
        this.remark = remark == null ? null : remark.trim();
    }

    /**
     * 获取状态（0、未完成 1、已完成）
     *
     * @return status - 状态（0、未完成 1、已完成）
     */
    public Byte getStatus() {
        return status;
    }

    /**
     * 设置状态（0、未完成 1、已完成）
     *
     * @param status 状态（0、未完成 1、已完成）
     */
    public void setStatus(Byte status) {
        this.status = status;
    }

    /**
     * 获取创建人
     *
     * @return create_by - 创建人
     */
    public Long getCreateBy() {
        return createBy;
    }

    /**
     * 设置创建人
     *
     * @param createBy 创建人
     */
    public void setCreateBy(Long createBy) {
        this.createBy = createBy;
    }

    /**
     * 获取创建时间
     *
     * @return create_date - 创建时间
     */
    public Date getCreateDate() {
        return createDate;
    }

    /**
     * 设置创建时间
     *
     * @param createDate 创建时间
     */
    public void setCreateDate(Date createDate) {
        this.createDate = createDate;
    }

    /**
     * 获取最后修改人ID
     *
     * @return update_by - 最后修改人ID
     */
    public Long getUpdateBy() {
        return updateBy;
    }

    /**
     * 设置最后修改人ID
     *
     * @param updateBy 最后修改人ID
     */
    public void setUpdateBy(Long updateBy) {
        this.updateBy = updateBy;
    }

    /**
     * 获取最后修改时间
     *
     * @return update_date - 最后修改时间
     */
    public Date getUpdateDate() {
        return updateDate;
    }

    /**
     * 设置最后修改时间
     *
     * @param updateDate 最后修改时间
     */
    public void setUpdateDate(Date updateDate) {
        this.updateDate = updateDate;
    }

    /**
     * 获取是否有效（0-无效，1-有效）
     *
     * @return is_valid - 是否有效（0-无效，1-有效）
     */
    public Boolean getIsValid() {
        return isValid;
    }

    /**
     * 设置是否有效（0-无效，1-有效）
     *
     * @param isValid 是否有效（0-无效，1-有效）
     */
    public void setIsValid(Boolean isValid) {
        this.isValid = isValid;
    }

	public String getCreateByName() {
		return createByName;
	}

	public void setCreateByName(String createByName) {
		this.createByName = createByName;
	}

	public List<EmeAccidentFiles> getPhotos() {
		return photos;
	}

	public void setPhotos(List<EmeAccidentFiles> photos) {
		this.photos = photos;
	}

	public List<EmeAccidentFiles> getReports() {
		return reports;
	}

	public void setReports(List<EmeAccidentFiles> reports) {
		this.reports = reports;
	}

	public List<EmeAccidentFiles> getOthers() {
		return others;
	}

	public void setOthers(List<EmeAccidentFiles> others) {
		this.others = others;
	}

	public String getLevelName() {
		return levelName;
	}

	public void setLevelName(String levelName) {
		this.levelName = levelName;
	}

	public Date getBeginTime() {
		return beginTime;
	}

	public void setBeginTime(Date beginTime) {
		this.beginTime = beginTime;
	}

	public Date getEndTime() {
		return endTime;
	}

	public void setEndTime(Date endTime) {
		this.endTime = endTime;
	}

	public String getHappenTimeStr() {
		if(this.happenTime==null) return "";
		SimpleDateFormat sdf = new SimpleDateFormat("YYYY-MM-dd HH:mm");
		this.happenTimeStr = sdf.format(this.happenTime);
		return happenTimeStr;
	}

	public void setHappenTimeStr(String happenTimeStr) {
		this.happenTimeStr = happenTimeStr;
	}

    public String getOrgId() {
        return orgId;
    }

    public void setOrgId(String orgId) {
        this.orgId = orgId;
    }
}