package cn.smarthse.modules.health.entity.sys.workremind;

import java.time.LocalDateTime;
import java.io.Serializable;
import java.util.Date;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import javax.persistence.Id;

/**
 * <p>
 * 首页工作更新提醒
 * </p>
 *
 * @author zhoulj@smarthse.cn
 * @since 2022-07-21
 */
@Data
public class SysWorkRemind implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * ID
     */
    @Id
    private Long id;

    /**
     * 企业ID
     */
    private Long cid;

    /**
     * 模块编码， 枚举类 HomeDataEvent
     */
    private String modelCode;

    /**
     * 更新状态（0：无更新，  1 有更新)
     */
    private Integer status;

    /**
     * 创建时间
     */
    private Date createDate;

    /**
     * 创建人
     */
    private Long createBy;

    /**
     * 最后修改时间
     */
    private Date updateDate;

    /**
     * 最后修改人ID
     */
    private Long updateBy;

    /**
     * 是否有效（0-无效，1-有效）
     */
    private Boolean isValid;


}
