/**
 * 
 */
package cn.smarthse.modules.health.entity.sys.vo;

import java.io.Serializable;
import java.util.List;

import lombok.Data;

import cn.smarthse.common.config.Global;
import cn.smarthse.modules.health.entity.sys.SecUserRole;

/**
 * 《用户表单》
 * 
 * 
 * @Project:  smarthse-facade1.0
 * @Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * @Comments:  <对此类的描述，可以引用系统设计中的描述>
 * @JDK version used:      <JDK1.7> 
 * @author JannyShao(邵建义) [ksgameboy@qq.com]
 * @since 2017-6-30-上午9:33:56
 */
public @Data class UserFormVO implements Serializable{
	private static final long serialVersionUID = -6220166915474419078L;

	/**
	 * 账号Id
	 */
	private Long userid;
	
	/**
	 * 账号
	 */
	private String username;
	
	/**
	 * 账号密码(md5加密)
	 */
	private String password;
	
	/**
	 * 是否禁用
	 */
	private Boolean isForbidden = Global.FALSE;
	
	/**
	 * 员工ID
	 * <li>该账号分配给
	 */
	private Long staffId;
	
	/**
	 * 员工姓名
	 */
	private String staffname;
	
	/**
	 * 用户分配的角色
	 */
	private List<SecUserRole> userRoleList;

	/**
	 * 昵称
	 */
	private String fullname;
}
