package cn.smarthse.modules.health.entity.sys.message;

import cn.smarthse.common.util.validation.DataValida;

import javax.persistence.*;
import java.io.Serializable;
import java.util.Date;

@Table(name = "sys_message")
public class SysMessage implements Serializable {
    /**
     * ID
     */
    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY, generator = "select RIGHT(uuid_short(), 19)")
    private Long id;
    /**
     * 企业ID
     */
    private Long cid;

    /**
     * 消息类型
     */
    @DataValida(max = "5",min="1",nullAble=false,name="消息类型")
    @Column(name = "message_type")
    private Byte messageType;

    /**
     * 消息链接，系统内相对url地址或外部系统全路径地址（点击该消息跳转到的页面）
     */
    @DataValida(nullAble=false,name="消息链接",minLength="1")
    @Column(name = "process_url")
    private String processUrl;

    /**
     * 消息标题
     */
    @DataValida(nullAble=false,name="消息标题",minLength="1")
    @Column(name = "message_title")
    private String messageTitle;

    /**
     * 消息编号
     */
    @DataValida(nullAble=false,name="消息编号",minLength="1")
    @Column(name = "message_sn")
    private String messageSn;

    /**
     * 消息来源，见枚举类MessageSourceEnum
     */
    @DataValida(max = "1",min="1",nullAble=false,name="消息来源")
    @Column(name = "message_source")
    private Byte messageSource;

    /**
     * 创建时间
     */
    @Column(name = "create_date")
    private Date createDate;

    /**
     * 创建人
     */
    @Column(name = "create_by")
    private Long createBy;

    /**
     * 最后修改时间
     */
    @Column(name = "update_date")
    private Date updateDate;

    /**
     * 最后修改人ID
     */
    @Column(name = "update_by")
    private Long updateBy;

    /**
     * 是否有效（0-无效，1-有效）
     */
    @Column(name = "is_valid")
    private Boolean isValid;

    private static final long serialVersionUID = 1L;

    /**
     * 获取ID
     *
     * @return id - ID
     */
    public Long getId() {
        return id;
    }

    /**
     * 设置ID
     *
     * @param id ID
     */
    public void setId(Long id) {
        this.id = id;
    }

    /**
     * 获取企业ID
     *
     * @return cid - 企业ID
     */
    public Long getCid() {
        return cid;
    }

    /**
     * 设置企业ID
     *
     * @param cid 企业ID
     */
    public void setCid(Long cid) {
        this.cid = cid;
    }

    /**
     * 获取消息类型
     *
     * @return message_type - 消息类型
     */
    public Byte getMessageType() {
        return messageType;
    }

    /**
     * 设置消息类型
     *
     * @param messageType 消息类型
     */
    public void setMessageType(Byte messageType) {
        this.messageType = messageType;
    }

    /**
     * 获取消息链接（点击该消息跳转到的页面）
     *
     * @return process_url - 消息链接（点击该消息跳转到的页面）
     */
    public String getProcessUrl() {
        return processUrl;
    }

    /**
     * 设置消息链接（点击该消息跳转到的页面）
     *
     * @param processUrl 消息链接（点击该消息跳转到的页面）
     */
    public void setProcessUrl(String processUrl) {
        this.processUrl = processUrl == null ? null : processUrl.trim();
    }

    /**
     * 获取消息标题
     *
     * @return message_title - 消息标题
     */
    public String getMessageTitle() {
        return messageTitle;
    }

    /**
     * 设置消息标题
     *
     * @param messageTitle 消息标题
     */
    public void setMessageTitle(String messageTitle) {
        this.messageTitle = messageTitle == null ? null : messageTitle.trim();
    }

    /**
     * 获取消息编号
     *
     * @return message_sn - 消息编号
     */
    public String getMessageSn() {
        return messageSn;
    }

    /**
     * 设置消息编号
     *
     * @param messageSn 消息编号
     */
    public void setMessageSn(String messageSn) {
        this.messageSn = messageSn == null ? null : messageSn.trim();
    }

    /**
     * 获取消息来源
     *
     * @return message_source - 消息来源
     */
    public Byte getMessageSource() {
        return messageSource;
    }

    /**
     * 设置消息来源
     *
     * @param messageSource 消息来源
     */
    public void setMessageSource(Byte messageSource) {
        this.messageSource = messageSource;
    }

    /**
     * 获取创建时间
     *
     * @return create_date - 创建时间
     */
    public Date getCreateDate() {
        return createDate;
    }

    /**
     * 设置创建时间
     *
     * @param createDate 创建时间
     */
    public void setCreateDate(Date createDate) {
        this.createDate = createDate;
    }

    /**
     * 获取创建人
     *
     * @return create_by - 创建人
     */
    public Long getCreateBy() {
        return createBy;
    }

    /**
     * 设置创建人
     *
     * @param createBy 创建人
     */
    public void setCreateBy(Long createBy) {
        this.createBy = createBy;
    }

    /**
     * 获取最后修改时间
     *
     * @return update_date - 最后修改时间
     */
    public Date getUpdateDate() {
        return updateDate;
    }

    /**
     * 设置最后修改时间
     *
     * @param updateDate 最后修改时间
     */
    public void setUpdateDate(Date updateDate) {
        this.updateDate = updateDate;
    }

    /**
     * 获取最后修改人ID
     *
     * @return update_by - 最后修改人ID
     */
    public Long getUpdateBy() {
        return updateBy;
    }

    /**
     * 设置最后修改人ID
     *
     * @param updateBy 最后修改人ID
     */
    public void setUpdateBy(Long updateBy) {
        this.updateBy = updateBy;
    }

    /**
     * 获取是否有效（0-无效，1-有效）
     *
     * @return is_valid - 是否有效（0-无效，1-有效）
     */
    public Boolean getIsValid() {
        return isValid;
    }

    /**
     * 设置是否有效（0-无效，1-有效）
     *
     * @param isValid 是否有效（0-无效，1-有效）
     */
    public void setIsValid(Boolean isValid) {
        this.isValid = isValid;
    }
}