package cn.smarthse.modules.health.entity.sys.message;

import cn.smarthse.modules.health.enums.sys.MessageBusinessTypeEnum;

import javax.persistence.*;
import java.io.Serializable;
import java.util.Date;
import java.util.List;

public class Message implements Serializable {

    private static final long serialVersionUID = 2534915824948160782L;

    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY, generator = "select RIGHT(uuid_short(), 19)")
    private Long id;

    private Long cid;

    /**
     * 业务id
     */
    @Column(name = "bussines_id")
    private Long bussinesId;

    /**
     * 业务类型
     */
    @Column(name = "bussines_type")
    private Byte bussinesType;

    /**
     * 业务类型（MessageBusinessTypeEnum.name）
     */
    @Transient
    private String typeName;

    /**
     * 业务类型（名称根据任务有所不同）
     * <p>
     * 1、提醒：根据具体情况描述；
     * 2、工作消息：工作名称+动作，动作包括：请审批；已审批；请反馈；有反馈；请查看；请开展工作；证书到期；
     * 3、通知公告：通知公告的名称；
     * 4、系统消息：系统版本更新；
     * 5、法律法规消息：法律法规名称+动作，动作包括：发布；作废；废止
     * 6、在线培训相关消息
     */
    @Column(name = "bussines_name")
    private String bussinesName;

    /**
     * 业务编号
     */
    @Column(name = "bussines_no")
    private String bussinesNo;

    /**
     * 业务来源类型
     * <p>
     * 101、评价工作管理
     * 102、隐患排查
     * 103、职业病危害因素检测
     * 104、工作计划
     * 201、隐患治理
     * 301、监管集团版通知公告
     * 302、监管通知公告
     * 303、运维培训视频通知公告
     * 401、法律法规
     * 501、系统更新
     * 601、在线培训
     */
    @Column(name = "bussines_from_type")
    private Integer bussinesFromType;

    /**
     * 业务来源
     * <p>
     * 1、提醒：根据具体情况描述
     * 2、工作消息：工作模块的名称
     * 3、通知公告：通知公告的发布单位
     * 4、系统消息：系统通知
     * 5、法律法规消息：系统通知
     * 6、在线培训消息
     */
    @Column(name = "bussines_from")
    private String bussinesFrom;

    /**
     * 发送时间
     */
    @Column(name = "send_time")
    private Date sendTime;

    /**
     * 链接地址
     */
    @Column(name = "process_url")
    private String processUrl;

    @Column(name = "create_user")
    private String createUser;

    @Column(name = "create_by")
    private Long createBy;

    @Column(name = "create_date")
    private Date createDate;

    @Column(name = "update_by")
    private Long updateBy;

    @Column(name = "update_date")
    private Date updateDate;

    @Column(name = "is_valid")
    private Boolean isValid;

    @Column(name = "area_id")
    private Long areaId;

    /**
     * 发送直属企业类型(0-非直属；1-省直属；2-市属；3-所有）
     */
    @Column(name = "send_belong")
    private Integer sendBelong;

    /**
     * 业务详情
     */
    @Column(name = "bussiness_content")
    private String bussinessContent;

    @Transient
    private Byte messageState;

    @Transient
    private List<MessageFile> files;

    @Transient
    private List<MessageReceiver> receivers;

    /**
     * @return id
     */
    public Long getId() {
        return id;
    }

    /**
     * @param id
     */
    public void setId(Long id) {
        this.id = id;
    }

    /**
     * @return cid
     */
    public Long getCid() {
        return cid;
    }

    /**
     * @param cid
     */
    public void setCid(Long cid) {
        this.cid = cid;
    }

    /**
     * 获取业务id
     *
     * @return bussines_id - 业务id
     */
    public Long getBussinesId() {
        return bussinesId;
    }

    /**
     * 设置业务id
     *
     * @param bussinesId 业务id
     */
    public void setBussinesId(Long bussinesId) {
        this.bussinesId = bussinesId;
    }

    /**
     * 获取业务类型（MessageBusinessTypeEnum）
     *
     * @return bussines_type - 业务类型（MessageBusinessTypeEnum）
     */
    public Byte getBussinesType() {
        return bussinesType;
    }

    /**
     * 设置业务类型（MessageBusinessTypeEnum）
     *
     * @param bussinesType 业务类型（MessageBusinessTypeEnum）
     */
    public void setBussinesType(Byte bussinesType) {
        this.bussinesType = bussinesType;
    }

    /**
     * 获取业务名称
     *
     * @return bussines_name - 业务名称
     */
    public String getBussinesName() {
        return bussinesName;
    }

    /**
     * 设置业务名称
     *
     * @param bussinesName 业务名称
     */
    public void setBussinesName(String bussinesName) {
        this.bussinesName = bussinesName == null ? null : bussinesName.trim();
    }

    /**
     * 获取业务编号
     *
     * @return bussines_no - 业务编号
     */
    public String getBussinesNo() {
        return bussinesNo;
    }

    /**
     * 设置业务编号
     *
     * @param bussinesNo 业务编号
     */
    public void setBussinesNo(String bussinesNo) {
        this.bussinesNo = bussinesNo == null ? null : bussinesNo.trim();
    }

    /**
     * 获取业务来源（1、提醒：根据具体情况描述；2、工作消息：工作模块的名称；3、通知公告：通知公告的发布单位；4、系统消息：系统通知；5、法律法规消息：系统通知）
     *
     * @return bussines_from - 业务来源（1、提醒：根据具体情况描述；2、工作消息：工作模块的名称；3、通知公告：通知公告的发布单位；4、系统消息：系统通知；5、法律法规消息：系统通知）
     */
    public String getBussinesFrom() {
        return bussinesFrom;
    }

    /**
     * 设置业务来源（1、提醒：根据具体情况描述；2、工作消息：工作模块的名称；3、通知公告：通知公告的发布单位；4、系统消息：系统通知；5、法律法规消息：系统通知）
     *
     * @param bussinesFrom 业务来源（1、提醒：根据具体情况描述；2、工作消息：工作模块的名称；3、通知公告：通知公告的发布单位；4、系统消息：系统通知；5、法律法规消息：系统通知）
     */
    public void setBussinesFrom(String bussinesFrom) {
        this.bussinesFrom = bussinesFrom == null ? null : bussinesFrom.trim();
    }

    /**
     * 获取发送时间
     *
     * @return send_time - 发送时间
     */
    public Date getSendTime() {
        return sendTime;
    }

    /**
     * 设置发送时间
     *
     * @param sendTime 发送时间
     */
    public void setSendTime(Date sendTime) {
        this.sendTime = sendTime;
    }

    /**
     * 获取链接地址
     *
     * @return process_url - 链接地址
     */
    public String getProcessUrl() {
        return processUrl;
    }

    /**
     * 设置链接地址
     *
     * @param processUrl 链接地址
     */
    public void setProcessUrl(String processUrl) {
        this.processUrl = processUrl == null ? null : processUrl.trim();
    }

    /**
     * 获取创建人名称
     *
     * @return create_user - 创建人名称
     */
    public String getCreateUser() {
        return createUser;
    }

    /**
     * 设置创建人名称
     *
     * @param createUser 创建人名称
     */
    public void setCreateUser(String createUser) {
        this.createUser = createUser == null ? null : createUser.trim();
    }

    /**
     * @return create_by
     */
    public Long getCreateBy() {
        return createBy;
    }

    /**
     * @param createBy
     */
    public void setCreateBy(Long createBy) {
        this.createBy = createBy;
    }

    /**
     * @return create_date
     */
    public Date getCreateDate() {
        return createDate;
    }

    /**
     * @param createDate
     */
    public void setCreateDate(Date createDate) {
        this.createDate = createDate;
    }

    /**
     * @return update_by
     */
    public Long getUpdateBy() {
        return updateBy;
    }

    /**
     * @param updateBy
     */
    public void setUpdateBy(Long updateBy) {
        this.updateBy = updateBy;
    }

    /**
     * @return update_date
     */
    public Date getUpdateDate() {
        return updateDate;
    }

    /**
     * @param updateDate
     */
    public void setUpdateDate(Date updateDate) {
        this.updateDate = updateDate;
    }

    /**
     * @return is_valid
     */
    public Boolean getIsValid() {
        return isValid;
    }

    /**
     * @param isVaild
     */
    public void setIsValid(Boolean isValid) {
        this.isValid = isValid;
    }

    /**
     * 获取业务详情
     *
     * @return bussiness_content - 业务详情
     */
    public String getBussinessContent() {
        return bussinessContent;
    }

    /**
     * 设置业务详情
     *
     * @param bussinessContent 业务详情
     */
    public void setBussinessContent(String bussinessContent) {
        this.bussinessContent = bussinessContent == null ? null : bussinessContent.trim();
    }

    public Byte getMessageState() {
        return messageState;
    }

    public void setMessageState(Byte messageState) {
        this.messageState = messageState;
    }

    public String getTypeName() {
        this.typeName = MessageBusinessTypeEnum.getName(this.bussinesType);
        return typeName;
    }

    public Integer getBussinesFromType() {

        return bussinesFromType;
    }

    public void setBussinesFromType(Integer bussinesFromType) {
        this.bussinesFromType = bussinesFromType;
    }

    public void setTypeName(String typeName) {
        this.typeName = typeName;
    }

    public List<MessageFile> getFiles() {
        return files;
    }

    public void setFiles(List<MessageFile> files) {
        this.files = files;
    }

    public List<MessageReceiver> getReceivers() {
        return receivers;
    }

    public void setReceivers(List<MessageReceiver> receivers) {
        this.receivers = receivers;
    }

    public Long getAreaId() {
        return areaId;
    }

    public void setAreaId(Long areaId) {
        this.areaId = areaId;
    }

    public Integer getSendBelong() {
        return sendBelong;
    }

    public void setSendBelong(Integer sendBelong) {
        this.sendBelong = sendBelong;
    }
}