package cn.smarthse.modules.health.entity.sys.legal;

import java.io.Serializable;
import java.util.Date;
import javax.persistence.*;

import lombok.Data;

/**
 * 
 * 《SysLegalUploadFile》
 * 
 * 
 * @Project:  smarthse-facade
 * @Module ID:   <4.10.2>
 * @Comments:  <法律法规文件上传>
 * @JDK version used:      <JDK1.7> 
 * @author 徐颖东 [xyd.900919@qq.com]
 * @since 2017-6-8-下午5:09:10
 */
@Table(name = "sys_legal_upload_file")
public @Data class SysLegalUploadFile implements Serializable {
    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY, generator = "select RIGHT(uuid_short(), 19)")
    private Long id;

    /**
     * 企业编号
     */
    private Long cid;

    /**
     * 法律法规ID
     */
    @Column(name = "legal_id")
    private Long legalId;

    /**
     * 上传文件ID
     */
    @Column(name = "file_id")
    private Long fileId;

    /**
     * 创建者
     */
    @Column(name = "create_by")
    private Long createBy;

    /**
     * 创建时间
     */
    @Column(name = "create_date")
    private Date createDate;

    /**
     * 最后修改者
     */
    @Column(name = "update_by")
    private Long updateBy;

    /**
     * 最后修改时间
     */
    @Column(name = "update_date")
    private Date updateDate;

    /**
     * 是否有效(1-有效,0-无效)
     */
    @Column(name = "is_valid")
    private Boolean isValid;
    /**
     * 数据来源表（1.系统法律法规表，2推荐法律法规表）
     */
    @Column(name = "from_table")
    private Integer fromTable;

    private static final long serialVersionUID = 1L;
}