package cn.smarthse.modules.health.entity.sys.legal;

import lombok.Data;

import javax.persistence.*;
import java.io.Serializable;
import java.util.Date;

/**
 * 
 * 《SysLegalFeedback》
 * 
 * 
 * @Project:  smarthse-facade
 * @Module ID:   <4.10.2>
 * @Comments:  <法律法规反馈>
 * @JDK version used:      <JDK1.7> 
 * @author 徐颖东 [xyd.900919@qq.com]
 * @since 2017-6-8-下午5:09:10
 */
@Table(name = "sys_legal_feedback")
public @Data class SysLegalFeedback implements Serializable {
    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY, generator = "select RIGHT(uuid_short(), 19)")
    private Long id;

    /**
     * 企业编号
     */
    private Long cid;

    /**
     * 法律法规ID
     */
    @Column(name = "legal_id")
    private Long legalId;

    /**
     * 法律法规标准名称
     */
    @Column(name = "feedback_name")
    private String feedbackName;

    /**
     * 法律法规标准号
     */
    @Column(name = "file_no")
    private String fileNo;

    /**
     * 反馈类型(1-新增,2-修改,3-废止,4-更新,5-其他)
     */
    @Column(name = "feedback_type")
    private Byte feedbackType;

    /**
     * 备注
     */
    private String remark;

    /**
     * 创建者
     */
    @Column(name = "create_by")
    private Long createBy;

    /**
     * 创建时间
     */
    @Column(name = "create_date")
    private Date createDate;

    /**
     * 最后修改者
     */
    @Column(name = "update_by")
    private Long updateBy;

    /**
     * 最后修改时间
     */
    @Column(name = "update_date")
    private Date updateDate;

    /**
     * 是否有效(1-有效,0-无效)
     */
    @Column(name = "is_valid")
    private Boolean isValid;
    /**
     * 数据来源表（1.系统法律法规表，2推荐法律法规表）
     */
    @Column(name = "from_table")
    private Integer fromTable;

    private static final long serialVersionUID = 1L;
}