package cn.smarthse.modules.health.entity.sys.legal;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

import javax.persistence.*;

import lombok.Data;

/**
 * 
 * 《SysLegal》
 * 
 * 
 * @Project:  smarthse-facade
 * @Module ID:   <4.10.2>
 * @Comments:  <法律法规>
 * @JDK version used:      <JDK1.7> 
 * @author 徐颖东 [xyd.900919@qq.com]
 * @since 2017-6-8-下午5:09:10
 */
@Table(name = "sys_legal")
public @Data class SysLegal implements Serializable {
    /**
     * 序号
     */
    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY, generator = "select RIGHT(uuid_short(), 19)")
    private Long id;

    /**
     * 中文名称
     */
    private String title;

    /**
     * 英文名称
     */
    @Column(name = "title_en")
    private String titleEn;

    /**
     * 法律法规标准号
     */
    @Column(name = "file_no")
    private String fileNo;

    /**
     * 状态(1-现行,2-作废, 3-即将实施,4-废止)
     * @see cn.smarthse.modules.health.enums.syslegal.SysLegalStatusEnum
     */
    @Column(name = "legal_status")
    private Integer legalStatus;

    /**
     * 中国标准文献分类
     */
    private String ccs;

    /**
     * 国际标准分类
     */
    private String ics;

    /**
     * 类型
     * @see cn.smarthse.modules.health.enums.syslegal.SysLegalTypeEnum
     */
    @Column(name = "legal_type")
    private Integer legalType;

    /**
     * 发布日期
     */
    @Column(name = "issuance_date")
    private Date issuanceDate;

    /**
     * 实施日期
     */
    @Column(name = "execute_date")
    private Date executeDate;

    /**
     * 作废日期
     */
    @Column(name = "lnvalid_date")
    private Date lnvalidDate;
    /**
     * 主管部门
     */
    private String governor;

    /**
     * 颁布部门
     */
    @Column(name = "department_issued")
    private String departmentIssued;

    /**
     * 链接
     */
    @Column(name = "web_lnk")
    private String webLnk;

    /**
     * 创建者
     */
    @Column(name = "create_by")
    private Long createBy;

    /**
     * 创建时间
     */
    @Column(name = "create_date")
    private Date createDate;

    /**
     * 最后修改者
     */
    @Column(name = "update_by")
    private Long updateBy;

    /**
     * 最后修改时间
     */
    @Column(name = "update_date")
    private Date updateDate;

    /**
     * 是否有效(1-有效,0-无效)
     */
    @Column(name = "is_valid")
    private Boolean isValid;
    
    @Column(name = "last_update_date")
    private Date lastUpdateDate;

    private static final long serialVersionUID = 1L;
    
    /**
     * 法律法规关注表legal_id(用来查看是否被关注)
     */
    @Transient
    private Long legalId;
    
    /**
     * 状态名
     */
    @Transient
    private String statusName;
    
    /**
     * 类型名
     */
    @Transient
    private String typeName;
    
    /**
     * 实施日期
     */
    @Transient
    private String date;
    /**
     * 数据来源表（1.系统法律法规表，2推荐法律法规表）
     */
    @Transient
    private Integer fromTable;
    
    /**
     * 附件id
     */
    @Transient
    private List<Long> fileIds;
    
    /**
     * 附件名
     */
    @Transient
    private List<String> fileNames;
}