package cn.smarthse.modules.health.entity.sys;

import lombok.Data;

import javax.persistence.*;
import java.io.Serializable;
import java.util.Date;
@Table(name = "sys_user_tip")
public @Data class SysUserTip implements Serializable {
	private static final long serialVersionUID = 5922477750792334910L;

	/**
     * ID
     */
    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY, generator = "select RIGHT(uuid_short(), 19)")
    private Long id;

    /**
     * 所属企业编号
     */
    private Long cid;
    @Column(name = "user_id")
    private Long userId;

    /**
     * 防治责任告知(0未确认， 1 已确认， 2元旦当天已确认)
     */
    @Column(name = "control_notif")
    private Integer controlNotif;
    /**
     * 防治责任告知 确认年份
     */
    @Column(name = "control_notif_year")
    private Integer controlNotifYear;


    /**
     * 是否有效（0-无效，1-有效）
     */
    @Column(name = "is_valid")
    private Boolean isValid;
    /**
     * 创建人
     */
    @Column(name = "create_by")
    private Long createBy;

    /**
     * 创建时间
     */
    @Column(name = "create_date")
    private Date createDate;

    /**
     * 最后修改人ID
     */
    @Column(name = "update_by")
    private Long updateBy;

    /**
     * 最后修改时间
     */
    @Column(name = "update_date")
    private Date updateDate;


}