package cn.smarthse.modules.health.entity.sys;

import java.io.Serializable;
import java.util.Date;
import javax.persistence.*;

@Table(name = "sys_user_login")
public class SysUserLogin implements Serializable {
    /**
     * ID
     */
    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY, generator = "select RIGHT(uuid_short(), 19)")
    private Long id;

    /**
     * 所属企业编号(所在企业)
     */
    private Long cid;

    /**
     * 用户id
     */
    @Column(name = "user_id")
    private Long userId;

    /**
     * token,登录唯一信息(可能用户名,可能手机,可能邮箱....)
     */
    private String token;

    /**
     * 登录类型(0-平台,1-手机,2-邮箱,3-微信,4-...)
     */
    @Column(name = "token_type")
    private Byte tokenType;

    /**
     * 是否有效（0-无效，1-有效）
     */
    @Column(name = "is_valid")
    private Boolean isValid;

    /**
     * 创建人
     */
    @Column(name = "create_by")
    private Long createBy;

    /**
     * 创建时间
     */
    @Column(name = "create_date")
    private Date createDate;

    /**
     * 最后修改人ID
     */
    @Column(name = "update_by")
    private Long updateBy;

    /**
     * 最后修改时间
     */
    @Column(name = "update_date")
    private Date updateDate;

    
    /**
     * 平台UserId(2.4版本)
     */
    @Column(name = "platform_user_id")
    private Long platformUserId;

    /**
     * 是否管理员(2.4版本)
     */
    @Column(name = "platform_is_manger")
    private Boolean platformIsManger;
    
    @Transient
    private String permissonCodes;

    
    private static final long serialVersionUID = 1L;

    /**
     * 获取ID
     *
     * @return id - ID
     */
    public Long getId() {
        return id;
    }

    /**
     * 设置ID
     *
     * @param id ID
     */
    public void setId(Long id) {
        this.id = id;
    }

    /**
     * 获取所属企业编号(所在企业)
     *
     * @return cid - 所属企业编号(所在企业)
     */
    public Long getCid() {
        return cid;
    }

    /**
     * 设置所属企业编号(所在企业)
     *
     * @param cid 所属企业编号(所在企业)
     */
    public void setCid(Long cid) {
        this.cid = cid;
    }

    /**
     * 获取用户id
     *
     * @return user_id - 用户id
     */
    public Long getUserId() {
        return userId;
    }

    /**
     * 设置用户id
     *
     * @param userId 用户id
     */
    public void setUserId(Long userId) {
        this.userId = userId;
    }

    /**
     * 获取token,登录唯一信息(可能用户名,可能手机,可能邮箱....)
     *
     * @return token - token,登录唯一信息(可能用户名,可能手机,可能邮箱....)
     */
    public String getToken() {
        return token;
    }

    /**
     * 设置token,登录唯一信息(可能用户名,可能手机,可能邮箱....)
     *
     * @param token token,登录唯一信息(可能用户名,可能手机,可能邮箱....)
     */
    public void setToken(String token) {
        this.token = token == null ? null : token.trim();
    }

    /**
     * 获取登录类型(0-平台,1-手机,2-邮箱,3-微信,4-...)
     *
     * @return token_type - 登录类型(0-平台,1-手机,2-邮箱,3-微信,4-...)
     */
    public Byte getTokenType() {
        return tokenType;
    }

    /**
     * 设置登录类型(0-平台,1-手机,2-邮箱,3-微信,4-...)
     *
     * @param tokenType 登录类型(0-平台,1-手机,2-邮箱,3-微信,4-...)
     */
    public void setTokenType(Byte tokenType) {
        this.tokenType = tokenType;
    }

    /**
     * 获取是否有效（0-无效，1-有效）
     *
     * @return is_valid - 是否有效（0-无效，1-有效）
     */
    public Boolean getIsValid() {
        return isValid;
    }

    /**
     * 设置是否有效（0-无效，1-有效）
     *
     * @param isValid 是否有效（0-无效，1-有效）
     */
    public void setIsValid(Boolean isValid) {
        this.isValid = isValid;
    }

    /**
     * 获取创建人
     *
     * @return create_by - 创建人
     */
    public Long getCreateBy() {
        return createBy;
    }

    /**
     * 设置创建人
     *
     * @param createBy 创建人
     */
    public void setCreateBy(Long createBy) {
        this.createBy = createBy;
    }

    /**
     * 获取创建时间
     *
     * @return create_date - 创建时间
     */
    public Date getCreateDate() {
        return createDate;
    }

    /**
     * 设置创建时间
     *
     * @param createDate 创建时间
     */
    public void setCreateDate(Date createDate) {
        this.createDate = createDate;
    }

    /**
     * 获取最后修改人ID
     *
     * @return update_by - 最后修改人ID
     */
    public Long getUpdateBy() {
        return updateBy;
    }

    /**
     * 设置最后修改人ID
     *
     * @param updateBy 最后修改人ID
     */
    public void setUpdateBy(Long updateBy) {
        this.updateBy = updateBy;
    }

    /**
     * 获取最后修改时间
     *
     * @return update_date - 最后修改时间
     */
    public Date getUpdateDate() {
        return updateDate;
    }

    /**
     * 设置最后修改时间
     *
     * @param updateDate 最后修改时间
     */
    public void setUpdateDate(Date updateDate) {
        this.updateDate = updateDate;
    }

	public Long getPlatformUserId() {
		return platformUserId;
	}

	public void setPlatformUserId(Long platformUserId) {
		this.platformUserId = platformUserId;
	}

	public Boolean getPlatformIsManger() {
		return platformIsManger;
	}

	public void setPlatformIsManger(Boolean platformIsManger) {
		this.platformIsManger = platformIsManger;
	}

	public String getPermissonCodes() {
		return permissonCodes;
	}

	public void setPermissonCodes(String permissonCodes) {
		this.permissonCodes = permissonCodes;
	}
    
}