package cn.smarthse.modules.health.entity.sys;

import java.io.Serializable;
import java.util.Date;
import javax.persistence.*;

import lombok.Data;

/**
 * 
 * 《用户自定义布局表》
 * 
 * 
 * @Project:  smarthse-facade1.0
 * @Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * @Comments:  <对此类的描述，可以引用系统设计中的描述>
 * @JDK version used:      <JDK1.7> 
 * @author JannyShao(邵建义) [ksgameboy@qq.com]
 * @since 2017-8-16-下午1:41:35
 */
@Table(name = "sys_user_layout")
public @Data class SysUserLayout implements Serializable {
	private static final long serialVersionUID = -9090255072837017686L;

	/**
     * ID
     */
    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY, generator = "select RIGHT(uuid_short(), 19)")
    private Long id;

    /**
     * 所属企业编号(所在企业)
     */
    private Long cid;

    /**
     * 员工ID
     */
    @Column(name = "staff_id")
    private Long staffId;

    /**
     * 自定义组名,1:base,基础信息,2:work关键工作,3:index首页
     */
    @Column(name = "layout_group")
    private String layoutGroup;

    /**
     * 元素节点的自定义属性编码,多个按逗号隔开
     */
    @Column(name = "layout_codes")
    private String layoutCodes;

    /**
     * 是否有效（0-无效，1-有效）
     */
    @Column(name = "is_valid")
    private Boolean isValid;

    /**
     * 创建时间
     */
    @Column(name = "create_date")
    private Date createDate;


    /**
     * 最后修改时间
     */
    @Column(name = "update_date")
    private Date updateDate;
}