package cn.smarthse.modules.health.entity.sys;

import lombok.Data;

import javax.persistence.*;
import java.io.Serializable;
import java.util.Date;

/**
 * 
 * 《用户邀请表》
 * 
 * 
 * @Project:  smarthse-facade1.0
 * @Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * @Comments:  <对此类的描述，可以引用系统设计中的描述>
 * @JDK version used:      <JDK1.7> 
 * @author JannyShao(邵建义) [ksgameboy@qq.com]
 * @since 2017-6-30-下午2:38:24
 */
@Table(name = "sys_user_invite")
public @Data class SysUserInvite implements Serializable {
	private static final long serialVersionUID = 3818546699537549660L;

	/**
     * ID
     */
    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY, generator = "select RIGHT(uuid_short(), 19)")
    private Long id;

    /**
     * 所属企业编号
     */
    private Long cid;

    /**
     * 用户编号
     */
    @Column(name = "sys_user_id")
    private Long sysUserId;

    /**
     * 用户账号(冗余)
     */
    @Column(name = "sys_user_name")
    private String sysUserName;
    
    /**
     * 邀请的员工编号
     */
    @Column(name = "invite_staff_id")
    private Long inviteStaffId;

    /**
     * 邀请状态(0-草稿，1-待确认，2-已确认，3-拒绝）
     */
    @Column(name = "invite_state")
    private Byte inviteState;

    /**
     * 是否有效（0-无效，1-有效）
     */
    @Column(name = "is_valid")
    private Boolean isValid;

    /**
     * 创建人
     */
    @Column(name = "create_by")
    private Long createBy;

    /**
     * 创建时间
     */
    @Column(name = "create_date")
    private Date createDate;

    /**
     * 最后修改人ID
     */
    @Column(name = "update_by")
    private Long updateBy;

    /**
     * 最后修改时间
     */
    @Column(name = "update_date")
    private Date updateDate;

    
    //==================数据属性定义====================
    /**
     * 员工姓名()
     */
    @Transient
    private String staffname;
    
}