package cn.smarthse.modules.health.entity.sys;

import lombok.Data;

import javax.persistence.*;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import java.util.Set;

/**
 * 《系统用户表》
 *
 * @author JannyShao(邵建义) [ksgameboy@qq.com]
 * @Project: GIIANTECH CORE
 * @Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * @Comments: <对此类的描述，可以引用系统设计中的描述>
 * @JDK version used:      <JDK1.7>
 * @since 2017-5-27-上午10:38:06
 */
@Table(name = "sys_user")
@Data
public class SysUser implements Serializable {

    private static final long serialVersionUID = 5922477750792334910L;

    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY, generator = "select RIGHT(uuid_short(), 19)")
    private Long id;

    /**
     * 所属企业编号
     */
    private Long cid;

    /**
     * 关联的员工编号
     * <li>注意事项1：当staffId为空时,用户登录后需要提示?
     */
    @Column(name = "staff_id")
    private Long staffId;

    /**
     * 用户名
     */
    private String username;

    /**
     * 登录加密密码（SHA-1）
     */
    private String password;

    /**
     * 登录盐值
     */
    private String salt;

    /**
     * 头像文件编号（file.id)
     */
    @Column(name = "face_id")
    private Long faceId;

    /**
     * 用户姓名
     */
    private String fullname;

    /**
     * 手机号码
     */
    private String mobile;

    /**
     * 是否有效（0-无效，1-有效）
     */
    @Column(name = "is_valid")
    private Boolean isValid;

    /**
     * 是否管理员
     */
    @Column(name = "is_manger")
    private Boolean isManger;

    /**
     * 是否禁用
     */
    @Column(name = "is_forbidden")
    private Boolean isForbidden;

    /**
     * 启用/禁用时间（is_forbidden=1 表示禁用时间）
     */
    private Date forbiddenUpdateTime;

    /**
     * 最近登录时间 (共享体系3.0.5 添加)
     */
    private Date lastLoginTime;

    /**
     * 是否是默认密码
     */
    private Boolean isDefaultPwd;

    /**
     * 创建人
     */
    @Column(name = "create_by")
    private Long createBy;

    /**
     * 创建时间
     */
    @Column(name = "create_date")
    private Date createDate;

    /**
     * 最后修改人ID
     */
    @Column(name = "update_by")
    private Long updateBy;

    /**
     * 最后修改时间
     */
    @Column(name = "update_date")
    private Date updateDate;

    @Column(name = "need_change_pwd")
    private Boolean needChangePwd;

    //===================TODO  数据属性===============================

    /**
     * 用户权限列表
     */
    @Transient
    private List<String> permissionList;

    /**
     * 用户角色列表
     */
    @Transient
    private List<String> roleList;

    /**
     * 数据权限范围(1：全厂，用cid标识；2：部门，与组织架构的code一致；3：个人，0)
     */
    @Transient
    private Integer dataScope;

    /**
     * 用户权限码列表
     */
    @Transient
    private Set<String> permissionCodeList;

    /**
     * 是否超级管理员
     */
    @Transient
    private Boolean isSuperManger;
}