package cn.smarthse.modules.health.entity.sys;

import lombok.Data;

import javax.persistence.*;
import java.io.Serializable;
import java.util.Date;

/**
 * 
 * 《系统提示表》
 * 系统中所有带?号对应的提示内容库
 * 
 * @Project:  smarthse-facade1.0
 * @Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * @Comments:  <对此类的描述，可以引用系统设计中的描述>
 * @JDK version used:      <JDK1.7> 
 * @author JannyShao(邵建义) [ksgameboy@qq.com]
 * @since 2017-8-23-上午9:11:40
 */
@Table(name = "sys_tip")
public @Data class SysTip implements Serializable {
	private static final long serialVersionUID = 4602754567012564492L;

	/**
     * ID
     */
    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY, generator = "select RIGHT(uuid_short(), 19)")
    private Long id;

    /**
     * 提示Code
     */
    @Column(name = "tip_code")
    private String tipCode;

    /**
     * 标题
     */
    @Column(name = "tip_title")
    private String tipTitle;

    /**
     * 规定如何定位弹出框（即 top|bottom|left|right|auto）。
            当指定为 auto 时，会动态调整弹出框。例如，如果 placement 是 "auto left"，弹出框将会尽可能显示在左边，在情况不允许的情况下它才会显示在右边。
     */
    @Column(name = "tip_placement")
    private String tipPlacement;

    /**
     * 定义如何触发弹出框： click| hover | focus | manual。您可以传递多个触发器，每个触发器之间用空格分隔。
     */
    @Column(name = "tip_trigger")
    private String tipTrigger;
    
    /**
     * 是否有效（0-无效，1-有效）
     */
    @Column(name = "is_valid")
    private Boolean isValid;

    /**
     * 创建人
     */
    @Column(name = "create_by")
    private Long createBy;

    /**
     * 创建时间
     */
    @Column(name = "create_date")
    private Date createDate;

    /**
     * 最后修改人ID
     */
    @Column(name = "update_by")
    private Long updateBy;

    /**
     * 最后修改时间
     */
    @Column(name = "update_date")
    private Date updateDate;

    /**
     * 内容
     */
    @Column(name = "tip_content")
    private String tipContent;

}