package cn.smarthse.modules.health.entity.sys;

import lombok.Data;

import javax.persistence.*;
import java.io.Serializable;
import java.util.Date;


/**
 * sys监督机构日志
 *
 * @author zhangxu
 * @date 2023-05-05
 */
@Table(name = "sys_supervise_org_log")
public @Data class SysSuperviseOrgLog implements Serializable {
	private static final long serialVersionUID = -982613299701783643L;

//    字段：序号，用人单位名称、变更前监督机构、变更后监督机构、操作账号、变更时间；
	/**
     * ID
     */
    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY, generator = "select RIGHT(uuid_short(), 19)")
    @Column(name = "id")
    private Long id;

    /**
     * 企业ID
     */
    @Column(name = "cid")
    private Long cid;

    @Transient
    private String companyName;

    /**
     * 改变之前
     */
    @Column(name = "change_before")
    private Long changeBefore;
    private String changeBeforeName;

    /**
     * 改变后
     */
    @Column(name = "change_after")
    private Long changeAfter;
    private String changeAfterName;

    /**
     * 变更时间
     */
    @Column(name = "change_time")
    private Date changeTime;

    /**
     * 操作账号(冗余)
     */
    @Transient
    private String userName;

    /**
     * 创建人
     */
    @Column(name = "create_by")
    private Long createBy;

    /**
     * 创建时间
     */
    @Column(name = "create_date")
    private Date createDate;

    /**
     * 最后修改人ID
     */
    @Column(name = "update_by")
    private Long updateBy;

    /**
     * 最后修改时间
     */
    @Column(name = "update_date")
    private Date updateDate;

    @Column(name = "is_valid")
    private Boolean isValid;

    @Transient
    private String searchKey;
    @Transient
    private Byte logSource;
    @Transient
    private Long areaId;
    @Transient
    private Byte areaLevel;
    @Transient
    private Long orgId;
}