package cn.smarthse.modules.health.entity.sys;

import lombok.Data;

import javax.persistence.*;
import java.io.Serializable;
import java.util.Date;


/**
 * sys监督对象日志
 *
 * @author zhangxu
 * @date 2023-05-05
 */
@Table(name = "sys_supervise_object_log")
public @Data class SysSuperviseObjectLog implements Serializable {
	private static final long serialVersionUID = -982613299701783643L;

// 序号，用人单位名称，变更类型（移入监督对象、移出监督对象）、数据来源（在线培训添加、申报系统、创得推送）——如果有多个来源，申报＞创得＞培训添加，操作账号、变更时间；

	/**
     * ID
     */
    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY, generator = "select RIGHT(uuid_short(), 19)")
    @Column(name = "id")
    private Long id;

    /**
     * 企业ID
     */
    @Column(name = "cid")
    private Long cid;

    @Transient
    private String companyName;

    /**
     * 变化类型(1:移入监督对象,2:移出监督对象)
     */
    @Column(name = "change_type")
    private Integer changeType;

    /**
     *  数据来源CompanyDataSourceEnum   申报＞创得＞培训添加
     */
    @Column(name = "source_type")
    private Integer sourceType;

    /**
     * 变更时间
     */
    @Column(name = "change_time")
    private Date changeTime;

    /**
     * 操作账号
     */
    @Transient
    private String userName;

    /**
     * 创建人
     */
    @Column(name = "create_by")
    private Long createBy;

    /**
     * 创建时间
     */
    @Column(name = "create_date")
    private Date createDate;

    /**
     * 最后修改人ID
     */
    @Column(name = "update_by")
    private Long updateBy;

    /**
     * 最后修改时间
     */
    @Column(name = "update_date")
    private Date updateDate;

    @Column(name = "is_valid")
    private Boolean isValid;

    @Transient
    private String searchKey;
    @Transient
    private Byte logSource;
    @Transient
    private Long areaId;
    @Transient
    private Byte areaLevel;
    @Transient
    private Long orgId;
}