package cn.smarthse.modules.health.entity.sys;

import java.io.Serializable;
import java.util.Date;
import javax.persistence.*;

import lombok.Data;

/**
 * 
 * 《系统调度器》
 * 
 * 
 * @Project:  GIIANTECH CORE
 * @Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * @Comments:  <对此类的描述，可以引用系统设计中的描述>
 * @JDK version used:      <JDK1.7> 
 * @author JannyShao(邵建义) [ksgameboy@qq.com]
 * @since 2017-6-6-上午10:11:23
 */
@Table(name = "sys_quartz_schedulejob")
public @Data class SysQuartzSchedulejob implements Serializable {
	private static final long serialVersionUID = 2049982901379480232L;

	 /**
     * ID
     */
    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY, generator = "select RIGHT(uuid_short(), 19)")
    private Long id;

    /**
     * 任务名称
     */
    @Column(name = "job_name")
    private String jobName;

    /**
     * 任务运行时间表达式
     */
    @Column(name = "cron_expression")
    private String cronExpression;

    /**
     * 任务别名
     */
    @Column(name = "alias_name")
    private String aliasName;

    /**
     * 任务分组
     */
    @Column(name = "job_group")
    private String jobGroup;

    /**
     * 触发器
     */
    @Column(name = "job_trigger")
    private String jobTrigger;

    /**
     * 任务状态
     */
    private Byte status;

    /**
     * 是否异步
     */
    @Column(name = "is_sync")
    private Boolean isSync;

    /**
     * 任务描述
     */
    private String description;

    /**
     * bean id
     */
    @Column(name = "bean_id")
    private String beanId;

    /**
     * 执行类
     */
    @Column(name = "bean_class")
    private String beanClass;

    /**
     * 企业ID
     */
    private Long cid;

    /**
     * 是否有效（0-无效，1-有效）
     */
    @Column(name = "is_valid")
    private Boolean isValid;

    /**
     * 创建人
     */
    @Column(name = "create_by")
    private Long createBy;

    /**
     * 创建时间
     */
    @Column(name = "create_date")
    private Date createDate;

    /**
     * 最后修改人ID
     */
    @Column(name = "update_by")
    private Long updateBy;

    /**
     * 最后修改时间
     */
    @Column(name = "update_date")
    private Date updateDate;

}