package cn.smarthse.modules.health.entity.sys;

import java.io.Serializable;
import java.util.Date;
import javax.persistence.*;

import lombok.Data;

/**
 * 
 * 《系统参数表》
 * 
 * 
 * @Project:  GIIANTECH CORE
 * @Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * @Comments:  <对此类的描述，可以引用系统设计中的描述>
 * @JDK version used:      <JDK1.7> 
 * @author JannyShao(邵建义) [ksgameboy@qq.com]
 * @since 2017-6-6-上午10:10:35
 */
@Table(name = "sys_param")
public @Data class SysParam implements Serializable {
	private static final long serialVersionUID = 207740900351136435L;

	/**
     * ID
     */
    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY, generator = "select RIGHT(uuid_short(), 19)")
    private Long id;

    /**
     * 企业id（为0时，所属系统数据）
     */
    private Long cid;

    /**
     * 父编号
     */
    private Long pid;

    /**
     * 参数类别(参数分组，用于取所有数据）
     */
    @Column(name = "param_group")
    private String paramGroup;

    /**
     * 参数编码
     */
    @Column(name = "param_code")
    private String paramCode;

    /**
     * 参数值
     */
    @Column(name = "param_value")
    private String paramValue;

    /**
     * 参数描述
     */
    private String description;

    /**
     * 是否有效（0-无效，1-有效）
     */
    @Column(name = "is_valid")
    private Boolean isValid;

    /**
     * 创建人
     */
    @Column(name = "create_by")
    private Long createBy;

    /**
     * 创建时间
     */
    @Column(name = "create_date")
    private Date createDate;

    /**
     * 最后修改人ID
     */
    @Column(name = "update_by")
    private Long updateBy;

    /**
     * 最后修改时间
     */
    @Column(name = "update_date")
    private Date updateDate;
    /**
     * 行业的一级编码
     */
    @Transient
    private String industryCode1;

}