package cn.smarthse.modules.health.entity.sys;

import lombok.Data;

import javax.persistence.*;
import java.io.Serializable;
import java.util.Date;

/**
 * 
 * 《系统物料表》
 * 
 * 
 * @Project:  smarthse-facade1.0
 * @Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * @Comments:  <对此类的描述，可以引用系统设计中的描述>
 * @JDK version used:      <JDK1.7> 
 * @author JannyShao(邵建义) [ksgameboy@qq.com]
 * @since 2017-6-12-下午4:19:10
 */
@Table(name = "sys_material")
public @Data class SysMaterial implements Serializable {
	private static final long serialVersionUID = 7522009431543172811L;

	/**
     * ID
     */
    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY, generator = "select RIGHT(uuid_short(), 19)")
    private Long id;

    /**
     * 企业ID
     */
    private Long cid;

    /**
     * 中文名称
     */
    @Column(name = "name_ch")
    private String nameCh;

    /**
     * 中文别名
     */
    @Column(name = "nickname_ch")
    private String nicknameCh;

    /**
     * 英文名称
     */
    @Column(name = "name_en")
    private String nameEn;

    /**
     * 英文别名
     */
    @Column(name = "nickname_en")
    private String nicknameEn;

    /**
     * 分子式
     */
    private String formula;

    /**
     * CAS编号
     */
    @Column(name = "cas_no")
    private String casNo;

    /**
     * 危险化学品目录序号
     */
    @Column(name = "hazardous_id")
    private Long hazardousId;

    /**
     * 是否危化品
     */
    @Column(name = "is_hazardous")
    private Boolean isHazardous;

    /**
     * 是否剧毒品
     */
    @Column(name = "is_etoxic")
    private Boolean isEtoxic;

    /**
     * 描述
     */
    private String description;

    /**
     * ICSC连接地址
     */
    @Column(name = "icsc_lnk")
    private String icscLnk;

    /**
     * 创建人
     */
    @Column(name = "create_by")
    private Long createBy;

    /**
     * 创建时间
     */
    @Column(name = "create_date")
    private Date createDate;

    /**
     * 最后修改人ID
     */
    @Column(name = "update_by")
    private Long updateBy;

    /**
     * 最后修改时间
     */
    @Column(name = "update_date")
    private Date updateDate;

    /**
     * 是否有效（0-无效，1-有效）
     */
    @Column(name = "is_valid")
    private Boolean isValid;
}