package cn.smarthse.modules.health.entity.sys;

import lombok.Data;

import javax.persistence.*;
import java.io.Serializable;
import java.util.Date;

/**
 * 
 * 《企业操作日志表》
 * 
 * 
 * @Project:  smarthse-facade1.0
 * @Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * @Comments:  <对此类的描述，可以引用系统设计中的描述>
 * @JDK version used:      <JDK1.7> 
 * @author JannyShao(邵建义) [ksgameboy@qq.com]
 * @since 2017-6-12-下午4:15:43
 */
@Table(name = "sys_login_stat")
public @Data class SysLoginStat implements Serializable {
	private static final long serialVersionUID = -982613299701783643L;
	
	/**
     * ID
     */
    @Id
    private Long id;

    /**
     * 企业ID
     */
    private Long cid;
    @Transient
    private String companyName;

    private Long loginCount;
    
    /**
     */
    private Date lastLoginDate;


    /**
     * 是否有效（0-无效，1-有效）
     */
    @Column(name = "is_valid")
    private Boolean isValid;


    /**
     * 创建人
     */
    @Column(name = "create_by")
    private Long createBy;

    /**
     * 创建时间
     */
    @Column(name = "create_date")
    private Date createDate;

    /**
     * 最后修改人ID
     */
    @Column(name = "update_by")
    private Long updateBy;

    /**
     * 最后修改时间
     */
    @Column(name = "update_date")
    private Date updateDate;

    /**
     * 日志来源（用户类型）(1-用人单位（企业端）,2-专业机构,3-监管）
     */
    @Column(name = "log_source")
    private Byte logSource;
    
  
}