package cn.smarthse.modules.health.entity.sys;

import java.io.Serializable;
import java.util.Date;
import javax.persistence.*;

@Table(name = "sys_core_work_todolist")
public class SysCoreWorkTodolist implements Serializable,Cloneable {
    /**
     * ID编号
     */
    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY, generator = "select RIGHT(uuid_short(), 19)")
    private Long id;

    /**
     * 企业ID
     */
    private Long cid;

    /**
     * 待办事项标题
     */
    private String title;

    /**
     * 响应动作的url地址
     */
    @Column(name = "action_url")
    private String actionUrl;

    /**
     * 关键工作模块ID（见枚举：CoreWorkEnum）
     */
    @Column(name = "core_work_id")
    private Byte coreWorkId;
    
    /**
     * 关键工作提示信息类型，见枚举:TodlistInfoTypeEnum
     */
    @Column(name = "info_type")
    private Byte infoType;

    /**
     * 标题后面的数量
     */
    private Integer number;

    /**
     * 补充url地址
     */
    @Column(name = "supplement_url")
    private String supplementUrl;

    /**
     * 业务ID
     */
    @Column(name = "business_id")
    private Long businessId;

    /**
     * 是否显示
     */
    @Column(name = "is_show")
    private Boolean isShow;

    /**
     * 创建时间
     */
    @Column(name = "create_date")
    private Date createDate;

    /**
     * 创建人
     */
    @Column(name = "create_by")
    private Long createBy;

    /**
     * 最后修改时间
     */
    @Column(name = "update_date")
    private Date updateDate;

    /**
     * 最后修改人ID
     */
    @Column(name = "update_by")
    private Long updateBy;

    /**
     * 是否有效（0-无效，1-有效）
     */
    @Column(name = "is_valid")
    private Boolean isValid;

    /**
     * 提示说明
     */
    @Column(name = "tip_content")
    private String tipContent;

    private static final long serialVersionUID = 1L;

    /**
     * 获取ID编号
     *
     * @return id - ID编号
     */
    public Long getId() {
        return id;
    }

    /**
     * 设置ID编号
     *
     * @param id ID编号
     */
    public void setId(Long id) {
        this.id = id;
    }

    /**
     * 获取企业ID
     *
     * @return cid - 企业ID
     */
    public Long getCid() {
        return cid;
    }

    /**
     * 设置企业ID
     *
     * @param cid 企业ID
     */
    public void setCid(Long cid) {
        this.cid = cid;
    }

    /**
     * 获取待办事项标题
     *
     * @return title - 待办事项标题
     */
    public String getTitle() {
        return title;
    }

    /**
     * 设置待办事项标题
     *
     * @param title 待办事项标题
     */
    public void setTitle(String title) {
        this.title = title == null ? null : title.trim();
    }

    /**
     * 获取响应动作的url地址
     *
     * @return action_url - 响应动作的url地址
     */
    public String getActionUrl() {
        return actionUrl;
    }

    /**
     * 设置响应动作的url地址
     *
     * @param actionUrl 响应动作的url地址
     */
    public void setActionUrl(String actionUrl) {
        this.actionUrl = actionUrl == null ? null : actionUrl.trim();
    }

    /**
     * 获取关键工作模块ID（见枚举：CoreWorkEnum）
     *
     * @return core_work_id - 关键工作模块ID（见枚举：CoreWorkEnum）
     */
    public Byte getCoreWorkId() {
        return coreWorkId;
    }

    /**
     * 设置关键工作模块ID（见枚举：CoreWorkEnum）
     *
     * @param coreWorkId 关键工作模块ID（见枚举：CoreWorkEnum）
     */
    public void setCoreWorkId(Byte coreWorkId) {
        this.coreWorkId = coreWorkId;
    }

    /**
     * 获取标题后面的数量
     *
     * @return number - 标题后面的数量
     */
    public Integer getNumber() {
        return number;
    }

    /**
     * 设置标题后面的数量
     *
     * @param number 标题后面的数量
     */
    public void setNumber(Integer number) {
        this.number = number;
    }

    /**
     * 获取补充url地址
     *
     * @return supplement_url - 补充url地址
     */
    public String getSupplementUrl() {
        return supplementUrl;
    }

    /**
     * 设置补充url地址
     *
     * @param supplementUrl 补充url地址
     */
    public void setSupplementUrl(String supplementUrl) {
        this.supplementUrl = supplementUrl == null ? null : supplementUrl.trim();
    }

    /**
     * 获取业务ID
     *
     * @return business_id - 业务ID
     */
    public Long getBusinessId() {
        return businessId;
    }

    /**
     * 设置业务ID
     *
     * @param businessId 业务ID
     */
    public void setBusinessId(Long businessId) {
        this.businessId = businessId;
    }

    /**
     * 获取是否显示
     *
     * @return is_show - 是否显示
     */
    public Boolean getIsShow() {
        return isShow;
    }

    /**
     * 设置是否显示
     *
     * @param isShow 是否显示
     */
    public void setIsShow(Boolean isShow) {
        this.isShow = isShow;
    }

    /**
     * 获取创建时间
     *
     * @return create_date - 创建时间
     */
    public Date getCreateDate() {
        return createDate;
    }

    /**
     * 设置创建时间
     *
     * @param createDate 创建时间
     */
    public void setCreateDate(Date createDate) {
        this.createDate = createDate;
    }

    /**
     * 获取创建人
     *
     * @return create_by - 创建人
     */
    public Long getCreateBy() {
        return createBy;
    }

    /**
     * 设置创建人
     *
     * @param createBy 创建人
     */
    public void setCreateBy(Long createBy) {
        this.createBy = createBy;
    }

    /**
     * 获取最后修改时间
     *
     * @return update_date - 最后修改时间
     */
    public Date getUpdateDate() {
        return updateDate;
    }

    /**
     * 设置最后修改时间
     *
     * @param updateDate 最后修改时间
     */
    public void setUpdateDate(Date updateDate) {
        this.updateDate = updateDate;
    }

    /**
     * 获取最后修改人ID
     *
     * @return update_by - 最后修改人ID
     */
    public Long getUpdateBy() {
        return updateBy;
    }

    /**
     * 设置最后修改人ID
     *
     * @param updateBy 最后修改人ID
     */
    public void setUpdateBy(Long updateBy) {
        this.updateBy = updateBy;
    }

    /**
     * 获取是否有效（0-无效，1-有效）
     *
     * @return is_valid - 是否有效（0-无效，1-有效）
     */
    public Boolean getIsValid() {
        return isValid;
    }

    /**
     * 设置是否有效（0-无效，1-有效）
     *
     * @param isValid 是否有效（0-无效，1-有效）
     */
    public void setIsValid(Boolean isValid) {
        this.isValid = isValid;
    }

    /**
     * 获取提示说明
     *
     * @return tip_content - 提示说明
     */
    public String getTipContent() {
        return tipContent;
    }

    /**
     * 设置提示说明
     *
     * @param tipContent 提示说明
     */
    public void setTipContent(String tipContent) {
        this.tipContent = tipContent == null ? null : tipContent.trim();
    }

	public Byte getInfoType() {
		return infoType;
	}

	public void setInfoType(Byte infoType) {
		this.infoType = infoType;
	}

	@Override
	public Object clone() throws CloneNotSupportedException {
		
		SysCoreWorkTodolist cloneObj=(SysCoreWorkTodolist)super.clone();
		
		return cloneObj;
	}
    
	
    
}