package cn.smarthse.modules.health.entity.sys;

import java.io.Serializable;
import java.util.Date;
import javax.persistence.*;

@Table(name = "sys_core_work_module_correlation")
public class SysCoreWorkModuleCorrelation implements Serializable {
    /**
     * ID编号
     */
    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY, generator = "select RIGHT(uuid_short(), 19)")
    private Long id;

    /**
     * 企业ID
     */
    private Long cid;

    /**
     * 来源模块
     */
    @Column(name = "source_module")
    private Byte sourceModule;

    /**
     * 目标模块
     */
    @Column(name = "des_module")
    private Byte desModule;

    /**
     * 来源业务ID
     */
    @Column(name = "surce_business_id")
    private Long surceBusinessId;

    /**
     * 目标业务ID
     */
    @Column(name = "des_business_id")
    private Long desBusinessId;

    /**
     * 状态：,
     */
    private Byte status;
    
    /**
     * 源业务阶段
     */
    @Column(name="stage_source")
    private Byte stageSource;

    /**
     * 业务名称
     */
    @Column(name = "business_name")
    private String businessName;

    /**
     * 业务状态（根据不同业务来定）
     */
    @Column(name = "business_state")
    private Byte businessState;

    /**
     * 创建时间
     */
    @Column(name = "create_date")
    private Date createDate;

    /**
     * 创建人
     */
    @Column(name = "create_by")
    private Long createBy;
    /**
     * 创建人
     */
    @Column(name = "source_org_id")
    private Long sourceOrgId;
    /**
     * 创建人
     */
    @Column(name = "source_createby_id")
    private Long sourceCreatebyId;

    /**
     * 最后修改时间
     */
    @Column(name = "update_date")
    private Date updateDate;

    /**
     * 最后修改人ID
     */
    @Column(name = "update_by")
    private Long updateBy;

    /**
     * 是否有效（0-无效，1-有效）
     */
    @Column(name = "is_valid")
    private Boolean isValid;

    private static final long serialVersionUID = 1L;

    public Byte getStageSource() {
		return stageSource;
	}

	public void setStageSource(Byte stageSource) {
		this.stageSource = stageSource;
	}

	/**
     * 获取ID编号
     *
     * @return id - ID编号
     */
    public Long getId() {
        return id;
    }

    /**
     * 设置ID编号
     *
     * @param id ID编号
     */
    public void setId(Long id) {
        this.id = id;
    }

    /**
     * 获取企业ID
     *
     * @return cid - 企业ID
     */
    public Long getCid() {
        return cid;
    }

    /**
     * 设置企业ID
     *
     * @param cid 企业ID
     */
    public void setCid(Long cid) {
        this.cid = cid;
    }

    /**
     * 获取来源模块
     *
     * @return source_module - 来源模块
     */
    public Byte getSourceModule() {
        return sourceModule;
    }

    /**
     * 设置来源模块
     *
     * @param sourceModule 来源模块
     */
    public void setSourceModule(Byte sourceModule) {
        this.sourceModule = sourceModule;
    }

    /**
     * 获取目标模块
     *
     * @return des_module - 目标模块
     */
    public Byte getDesModule() {
        return desModule;
    }

    /**
     * 设置目标模块
     *
     * @param desModule 目标模块
     */
    public void setDesModule(Byte desModule) {
        this.desModule = desModule;
    }

    /**
     * 获取来源业务ID
     *
     * @return surce_business_id - 来源业务ID
     */
    public Long getSurceBusinessId() {
        return surceBusinessId;
    }

    /**
     * 设置来源业务ID
     *
     * @param surceBusinessId 来源业务ID
     */
    public void setSurceBusinessId(Long surceBusinessId) {
        this.surceBusinessId = surceBusinessId;
    }

    /**
     * 获取目标业务ID
     *
     * @return des_business_id - 目标业务ID
     */
    public Long getDesBusinessId() {
        return desBusinessId;
    }

    /**
     * 设置目标业务ID
     *
     * @param desBusinessId 目标业务ID
     */
    public void setDesBusinessId(Long desBusinessId) {
        this.desBusinessId = desBusinessId;
    }

    /**
     * 获取状态：,
     *
     * @return status - 状态：,
     */
    public Byte getStatus() {
        return status;
    }

    /**
     * 设置状态：,
     *
     * @param status 状态：,
     */
    public void setStatus(Byte status) {
        this.status = status;
    }

    /**
     * 获取业务名称
     *
     * @return business_name - 业务名称
     */
    public String getBusinessName() {
        return businessName;
    }

    /**
     * 设置业务名称
     *
     * @param businessName 业务名称
     */
    public void setBusinessName(String businessName) {
        this.businessName = businessName == null ? null : businessName.trim();
    }

    /**
     * 获取创建时间
     *
     * @return create_date - 创建时间
     */
    public Date getCreateDate() {
        return createDate;
    }

    /**
     * 设置创建时间
     *
     * @param createDate 创建时间
     */
    public void setCreateDate(Date createDate) {
        this.createDate = createDate;
    }

    /**
     * 获取创建人
     *
     * @return create_by - 创建人
     */
    public Long getCreateBy() {
        return createBy;
    }

    /**
     * 设置创建人
     *
     * @param createBy 创建人
     */
    public void setCreateBy(Long createBy) {
        this.createBy = createBy;
    }

    /**
     * 获取最后修改时间
     *
     * @return update_date - 最后修改时间
     */
    public Date getUpdateDate() {
        return updateDate;
    }

    /**
     * 设置最后修改时间
     *
     * @param updateDate 最后修改时间
     */
    public void setUpdateDate(Date updateDate) {
        this.updateDate = updateDate;
    }

    /**
     * 获取最后修改人ID
     *
     * @return update_by - 最后修改人ID
     */
    public Long getUpdateBy() {
        return updateBy;
    }

    /**
     * 设置最后修改人ID
     *
     * @param updateBy 最后修改人ID
     */
    public void setUpdateBy(Long updateBy) {
        this.updateBy = updateBy;
    }

    /**
     * 获取是否有效（0-无效，1-有效）
     *
     * @return is_valid - 是否有效（0-无效，1-有效）
     */
    public Boolean getIsValid() {
        return isValid;
    }

    /**
     * 设置是否有效（0-无效，1-有效）
     *
     * @param isValid 是否有效（0-无效，1-有效）
     */
    public void setIsValid(Boolean isValid) {
        this.isValid = isValid;
    }

    public Long getSourceOrgId() {
        return sourceOrgId;
    }

    public void setSourceOrgId(Long sourceOrgId) {
        this.sourceOrgId = sourceOrgId;
    }

    public Long getSourceCreatebyId() {
        return sourceCreatebyId;
    }

    public void setSourceCreatebyId(Long sourceCreatebyId) {
        this.sourceCreatebyId = sourceCreatebyId;
    }

    public Byte getBusinessState() {
        return businessState;
    }

    public void setBusinessState(Byte businessState) {
        this.businessState = businessState;
    }
}