package cn.smarthse.modules.health.entity.sys;

import lombok.Data;

import javax.persistence.*;
import java.io.Serializable;

/**
 * 
 * 《行政区划表》
 * 
 * 
 * @Project:  GIIANTECH CORE
 * @Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * @Comments:  <对此类的描述，可以引用系统设计中的描述>
 * @JDK version used:      <JDK1.7> 
 * @author JannyShao(邵建义) [ksgameboy@qq.com]
 * @since 2017-6-5-下午4:57:37
 */
@Table(name = "sys_area")
public @Data class SysArea implements Serializable {
	private static final long serialVersionUID = 3206627200492433489L;

	/**
     * ID
     */
    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY, generator = "select RIGHT(uuid_short(), 19)")
    private Long id;

    /**
     * 父编号
     */
    @Column(name = "parent_id")
    private Long parentId;

    /**
     * 简称
     */
    @Column(name = "short_name")
    private String shortName;

    /**
     * 名称
     */
    private String name;

    /**
     * 经度
     */
    private String lng;

    /**
     * 纬度
     */
    private String lat;

    /**
     * 级别(0-国家,1-省,2-市,3-区,4-乡,5-村)
     */
    private Byte level;

    /**
     * 热度
     */
    @Column(name = "order_by")
    private Integer orderBy;

    /**
     * 省编号
     */
    @Column(name = "province_id")
    private Long provinceId;

    /**
     * 省名称
     */
    @Column(name = "province_name")
    private String provinceName;

    /**
     * 市编号
     */
    @Column(name = "city_id")
    private Long cityId;

    /**
     * 市名称
     */
    @Column(name = "city_name")
    private String cityName;

    /**
     * 区域ID
     */
    @Column(name = "area_id")
    private Long areaId;

    /**
     * 区域名称
     */
    @Column(name = "area_name")
    private String areaName;

    /**
     * 乡镇街道编号
     */
    @Column(name = "street_id")
    private Long streetId;

    /**
     * 乡镇街道名称
     */
    @Column(name = "street_name")
    private String streetName;

    /**
     * 是否有效（0-无效，1-有效）
     */
    @Column(name = "is_valid")
    private Boolean isValid;

    /**
	 * 行政区域全名
	 * 
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author JannyShao(邵建义) [ksgameboy@qq.com]
	 * @since 2019年3月19日-下午1:05:24
	 * @return
	 */
	public String getAreaDetailName() {
		
		StringBuffer result = new StringBuffer();
		//provinceName cityName areaName streetName
		//省
		if(provinceName != null && provinceName!=""){
			result.append(provinceName); //.append("/");
		}
		//市
		if(cityName != null && cityName!=""){
			result.append(cityName); //.append("/");
		}
		//区县
		if(areaName != null && areaName!=""){
			result.append(areaName); //.append("/");
		}
		//街道
		if(streetName != null && streetName!=""){
			result.append(streetName); //.append("/");
		}
		
		return result.toString();
	}
    
}