package cn.smarthse.modules.health.entity.sys;

import lombok.Data;

import javax.persistence.*;
import java.io.Serializable;
import java.util.Date;

/**
 * 
 * 《系统角色表》
 * 
 * 
 * @Project:  GIIANTECH CORE
 * @Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * @Comments:  <对此类的描述，可以引用系统设计中的描述>
 * @JDK version used:      <JDK1.7> 
 * @author JannyShao(邵建义) [ksgameboy@qq.com]
 * @since 2017-5-24-下午4:24:19
 */
@Table(name = "sec_role")
public @Data class SecRole implements Serializable {
	private static final long serialVersionUID = 4824409636117751417L;

	/**
     * ID
     */
    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY, generator = "select RIGHT(uuid_short(), 19)")
    private Long id;

    /**
     * 企业ID
     */
    private Long cid;

    /**
     * 角色名称
     */
    private String rolename;

    /**
     * 角色描述
     */
    private String description;
    /**
     * 数据权限
     */
    private Byte dataScope;
    /**
     * 是否有效（0-无效，1-有效）
     */
    @Column(name = "is_valid")
    private Boolean isValid;

    /**
     * 创建人
     */
    @Column(name = "create_by")
    private Long createBy;

    /**
     * 创建时间
     */
    @Column(name = "create_date")
    private Date createDate;

    /**
     * 最后修改人ID
     */
    @Column(name = "update_by")
    private Long updateBy;

    /**
     * 最后修改时间
     */
    @Column(name = "update_date")
    private Date updateDate;
    
    /**
     * 用户与角色关联id（如果不为空则代表用户有该角色）
     * */
    @Transient
    private Long secUserRoleId;
    
    /**
     * 是否是超级管理员
     */
    @Column(name = "is_super_manager")
    private Boolean isSuperManager;

    
}