package cn.smarthse.modules.health.entity.sys;

import java.io.Serializable;
import java.util.Date;
import javax.persistence.*;

import lombok.Data;

/**
 * 
 * 《系统资源表》
 * 
 * 
 * @Project:  GIIANTECH CORE
 * @Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * @Comments:  <对此类的描述，可以引用系统设计中的描述>
 * @JDK version used:      <JDK1.7> 
 * @author JannyShao(邵建义) [ksgameboy@qq.com]
 * @since 2017-6-5-上午9:08:20
 */
@Table(name = "sec_resource")
public @Data class SecResource implements Serializable {
	private static final long serialVersionUID = 5744709412045829702L;

	 /**
     * ID
     */
    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY, generator = "select RIGHT(uuid_short(), 19)")
    private Long id;

    /**
     * 父级编号
     */
    @Column(name = "parent_id")
    private Long parentId;

    /**
     * 所有父级编号
     */
    @Column(name = "parent_ids")
    private String parentIds;

    /**
     * 资源分组编码
     */
    @Column(name = "group_code")
    private String groupCode;

    /**
     * 资源编码
     */
    @Column(name = "resource_code")
    private String resourceCode;

    /**
     * 资源名称
     */
    private String name;

    /**
     * 资源链接
     */
    private String link;

    /**
     * 目标（ mainFrame、_blank、_self、_parent、_top）
     */
    private String target;

    /**
     * 图标（在样式中的class）
     */
    private String icon;

    /**
     * 排序
     */
    @Column(name = "order_by")
    private Integer orderBy;

    /**
     * 是否在菜单中显示（1：显示；0：不显示）
     */
    @Column(name = "is_show")
    private Boolean isShow;

    /**
     * 是否有效（0-无效，1-有效）
     */
    @Column(name = "is_valid")
    private Boolean isValid;

    /**
     * 创建人
     */
    @Column(name = "create_by")
    private Long createBy;

    /**
     * 创建时间
     */
    @Column(name = "create_date")
    private Date createDate;

    /**
     * 最后修改人ID
     */
    @Column(name = "update_by")
    private Long updateBy;

    /**
     * 最后修改时间
     */
    @Column(name = "update_date")
    private Date updateDate;

   
}