package cn.smarthse.modules.health.entity.sys;

import lombok.Data;

import javax.persistence.*;
import java.io.Serializable;
import java.util.Date;

/**
 * 
 * 《权限表》
 * 
 * 
 * @Project:  GIIANTECH CORE
 * @Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * @Comments:  <对此类的描述，可以引用系统设计中的描述>
 * @JDK version used:      <JDK1.7> 
 * @author JannyShao(邵建义) [ksgameboy@qq.com]
 * @since 2017-5-24-下午4:25:12
 */
@Table(name = "sec_permission")
public @Data class SecPermission implements Serializable {
	private static final long serialVersionUID = -2647687120313852254L;

	 /**
     * ID
     */
    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY, generator = "select RIGHT(uuid_short(), 19)")
    private Long id;
    
    /**
     * 父级编号
     */
    @Column(name = "parent_id")
    private Long parentId;
    
    @Transient
    private String parentName;

    /**
     * 所有父级编号
     */
    @Column(name = "parent_ids")
    private String parentIds;

    /**
     * 资源编号
     */
    @Column(name = "sec_resource_id")
    private Long secResourceId;

    /**
     * 权限名称
     */
    @Column(name = "permission_name")
    private String permissionName;

    /**
     * 权限编码
     */
    @Column(name = "permission_code")
    private String permissionCode;

    /**
     * 权限分组（查看组、:编辑组）
     */
    @Column(name = "permission_group")
    private String permissionGroup;

    /**
     * 权限版本号(例如软件基础版、专家版、企业版）
     */
    @Column(name = "permission_version")
    private String permissionVersion;
    
    /**
     * 权限描述
     */
    private String description;

    /**
     * 是否有效（0-无效，1-有效）
     */
    @Column(name = "is_valid")
    private Boolean isValid;

    /**
     * 创建人
     */
    @Column(name = "create_by")
    private Long createBy;

    /**
     * 创建时间
     */
    @Column(name = "create_date")
    private Date createDate;

    /**
     * 最后修改人ID
     */
    @Column(name = "update_by")
    private Long updateBy;

    /**
     * 最后修改时间
     */
    @Column(name = "update_date")
    private Date updateDate;

    //=========TODO 以下为数据属性========================
    //父实体
    @Transient
    private SecPermission parent;
}