package cn.smarthse.modules.health.entity.sys;

import lombok.Data;

import javax.persistence.*;
import java.io.Serializable;
import java.util.Date;

/**
 * @author Zhoucl
 * @date 2022/1/10 9:17
 * @desc
 */
@Table(name = "project_feedback")
@Data
public class ProjectFeedBack implements Serializable {
    /**
     * id
     */
    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY, generator = "select RIGHT(uuid_short(), 19)")
    private Long id;

    /**
     * 项目id
     */
    @Column(name = "project_id")
    private Long projectId;


    private Long cid;

    private Long thirdorgId;

    /**
     * 项目类型(1、体检 2、评价 3、培训 4、职业病人 5、检测)
     */
    @Column(name = "type")
    private Byte type;

    /**
     * 反馈内容
     */
    @Column(name = "content")
    private String content;

    /**
     * 创建人
     */
    @Column(name = "create_by")
    private Long createBy;

    /**
     * 创建时间
     */
    @Column(name = "create_date")
    private Date createDate;

    /**
     * 最后修改人ID
     */
    @Column(name = "update_by")
    private Long updateBy;

    /**
     * 最后修改时间
     */
    @Column(name = "update_date")
    private Date updateDate;

    /**
     * 是否有效（0-无效，1-有效）
     */
    @Column(name = "is_valid")
    private Boolean isValid;

    /**
     * 是否处理（0-未处理 1-已处理  2-已忽略）
     */
    private Integer isHandle;

}
