package cn.smarthse.modules.health.entity.sys;

import lombok.Data;

import javax.persistence.*;
import java.io.Serializable;
import java.util.Date;

/**
 * 《》
 * 
 * 
 * @Project:  smarthse-entity
 * @Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * @Comments:  <对此类的描述，可以引用系统设计中的描述>
 * @JDK version used:      <JDK1.7> 
 * @author XiaoYi（肖奕)
 * @since 2020年3月5日-下午2:33:17
 */
@Table(name = "param")
public @Data class Param implements Serializable {
	private static final long serialVersionUID = 207740900352456435L;

	/**
     * ID
     */
    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY, generator = "select RIGHT(uuid_short(), 19)")
    private Long id;

   

    /**
     * 参数名称
     */
    private String name;
    /**
     * 所属企业编号
     */
    private Long cid;
    
    /**
     * 参数键名
     */
    @Column(name = "param_key")
    private String paramKey;
    
    /**
     * 参数键值
     */
    @Column(name = "param_value")
    private String paramValue;

    /**
     * 参数描述
     */
    @Column(name = "param_describe")
    private String paramDescribe;

    /**
     * 是否有效（0-无效，1-有效）
     */
    @Column(name = "is_valid")
    private Boolean isValid;

    /**
     * 创建人
     */
    @Column(name = "create_by")
    private Long createBy;

    /**
     * 创建时间
     */
    @Column(name = "create_date")
    private Date createDate;

    /**
     * 最后修改人ID
     */
    @Column(name = "update_by")
    private Long updateBy;

    /**
     * 最后修改时间
     */
    @Column(name = "update_date")
    private Date updateDate;
    /**
     * 查询关键字
     */
    @Transient
    private String keyWord;

}