package cn.smarthse.modules.health.entity.sys;

import java.io.Serializable;
import java.util.Date;

import javax.persistence.Column;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.persistence.Transient;

@Table(name = "history_basic")
public class HistoryBasic implements Serializable {
    /**
     * ID
     */
    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY, generator = "select RIGHT(uuid_short(), 19)")
    private Long id;

    /**
     * 企业ID
     */
    private Long cid;
    
	/**
     * 基础信息类型，表对应枚举ID
     */
    @Column(name = "basic_type")
    private String basicType;

    /**
     * 基础信息ID
     */
    @Column(name = "basic_id")
    private Long basicId;

    /**
     * 历史记录时间（此时间点之后，该基础信息做了修改）
     */
    @Column(name = "history_date")
    private Date historyDate;

    /**
     * 创建人
     */
    @Column(name = "create_by")
    private Long createBy;

    /**
     * 创建时间
     */
    @Column(name = "create_date")
    private Date createDate;

    /**
     * 最后修改人ID
     */
    @Column(name = "update_by")
    private Long updateBy;

    /**
     * 最后修改时间
     */
    @Column(name = "update_date")
    private Date updateDate;

    /**
     * 是否有效（0-无效，1-有效）
     */
    @Column(name = "is_valid")
    private Boolean isValid;

    /**
     * 历史内容
     */
    @Column(name = "history_content")
    private String historyContent;
    
    /**
     * 虚拟字段，更新的时候不能赋值
     */
    @Column(name= "v_updateDate")
    private Long vUpdateDate;
    
    @Transient
    private String actionType;

    private static final long serialVersionUID = 1L;

    public String getActionType() {
		return actionType;
	}

	public void setActionType(String actionType) {
		this.actionType = actionType;
	}

	/**
     * 获取ID
     *
     * @return id - ID
     */
    public Long getId() {
        return id;
    }

    /**
     * 设置ID
     *
     * @param id ID
     */
    public void setId(Long id) {
        this.id = id;
    }

    /**
     * 获取企业ID
     *
     * @return cid - 企业ID
     */
    public Long getCid() {
        return cid;
    }

    /**
     * 设置企业ID
     *
     * @param cid 企业ID
     */
    public void setCid(Long cid) {
        this.cid = cid;
    }

    /**
     * 获取基础信息类型，表对应的枚举ID
     *
     * @return basic_type - 基础信息类型，表对应的枚举ID
     */
    public String getBasicType() {
        return basicType;
    }

    /**
     * 设置基础信息类型，表对应的枚举ID
     *
     * @param basicType 基础信息类型，表对应的枚举ID
     */
    public void setBasicType(String basicType) {
        this.basicType = basicType== null ? null :basicType.trim();
    }

    /**
     * 获取基础信息ID
     *
     * @return basic_id - 基础信息ID
     */
    public Long getBasicId() {
        return basicId;
    }

    /**
     * 设置基础信息ID
     *
     * @param basicId 基础信息ID
     */
    public void setBasicId(Long basicId) {
        this.basicId = basicId;
    }

    /**
     * 获取历史记录时间（此时间点之后，该基础信息做了修改）
     *
     * @return history_date - 历史记录时间（此时间点之后，该基础信息做了修改）
     */
    public Date getHistoryDate() {
        return historyDate;
    }

    /**
     * 设置历史记录时间（此时间点之后，该基础信息做了修改）
     *
     * @param historyDate 历史记录时间（此时间点之后，该基础信息做了修改）
     */
    public void setHistoryDate(Date historyDate) {
        this.historyDate = historyDate;
    }

    /**
     * 获取创建人
     *
     * @return create_by - 创建人
     */
    public Long getCreateBy() {
        return createBy;
    }

    /**
     * 设置创建人
     *
     * @param createBy 创建人
     */
    public void setCreateBy(Long createBy) {
        this.createBy = createBy;
    }

    /**
     * 获取创建时间
     *
     * @return create_date - 创建时间
     */
    public Date getCreateDate() {
        return createDate;
    }

    /**
     * 设置创建时间
     *
     * @param createDate 创建时间
     */
    public void setCreateDate(Date createDate) {
        this.createDate = createDate;
    }

    /**
     * 获取最后修改人ID
     *
     * @return update_by - 最后修改人ID
     */
    public Long getUpdateBy() {
        return updateBy;
    }

    /**
     * 设置最后修改人ID
     *
     * @param updateBy 最后修改人ID
     */
    public void setUpdateBy(Long updateBy) {
        this.updateBy = updateBy;
    }

    /**
     * 获取最后修改时间
     *
     * @return update_date - 最后修改时间
     */
    public Date getUpdateDate() {
        return updateDate;
    }

    /**
     * 设置最后修改时间
     *
     * @param updateDate 最后修改时间
     */
    public void setUpdateDate(Date updateDate) {
        this.updateDate = updateDate;
    }

    /**
     * 获取是否有效（0-无效，1-有效）
     *
     * @return is_valid - 是否有效（0-无效，1-有效）
     */
    public Boolean getIsValid() {
        return isValid;
    }

    /**
     * 设置是否有效（0-无效，1-有效）
     *
     * @param isValid 是否有效（0-无效，1-有效）
     */
    public void setIsValid(Boolean isValid) {
        this.isValid = isValid;
    }

    /**
     * 获取历史内容
     *
     * @return history_content - 历史内容
     */
    public String getHistoryContent() {
        return historyContent;
    }

    /**
     * 设置历史内容
     *
     * @param historyContent 历史内容
     */
    public void setHistoryContent(String historyContent) {
        this.historyContent = historyContent == null ? null : historyContent.trim();
    }

	public Long getvUpdateDate() {
		return vUpdateDate;
	}

	public void setvUpdateDate(Long vUpdateDate) {
		this.vUpdateDate = vUpdateDate;
	}
    
    
}