package cn.smarthse.modules.health.entity.standard;

import javax.persistence.*;
import java.io.Serializable;

@Table(name = "l_08_3_occupational_risk_factors_fc")
public class L083OccupationalRiskFactorsFc implements Serializable {
    /**
     * 总表序号
     */
    @Id
    @Column(name = "ID_list")
    @GeneratedValue(strategy = GenerationType.IDENTITY, generator = "select RIGHT(uuid_short(), 19)")
    private Integer idList;

    /**
     * 代码
     */
    @Column(name = "paramCode")
    private String paramcode;

    /**
     * 名称_分类目录
     */
    @Column(name = "Name_CH")
    private String nameCh;

    /**
     * CAS号
     */
    @Column(name = "CASNo")
    private String casno;

    /**
     * CAS号备注
     */
    @Column(name = "Remarks_CASNo")
    private String remarksCasno;

    /**
     * 序号_分类目录
     */
    @Column(name = "ID_catalogue")
    private String idCatalogue;

    /**
     * 序号_GBZ2.1粉尘
     */
    @Column(name = "ID_FC")
    private Integer idFc;

    /**
     * 中文名_粉尘
     */
    @Column(name = "Name_CH_FC")
    private String nameChFc;

    /**
     * 英文名_粉尘
     */
    @Column(name = "Name_EN_FC")
    private String nameEnFc;

    /**
     * PC-TWA总尘(mg/m3)
     */
    @Column(name = "PC_TWA_Total_dust")
    private Float pcTwaTotalDust;

    /**
     * PC-TWA呼尘(mg/m3)
     */
    @Column(name = "PC_TWA_Respirable_dust")
    private Float pcTwaRespirableDust;

    /**
     * 最大超限倍数_粉尘
     */
    @Column(name = "Max_excursion_limit_FC")
    private Float maxExcursionLimitFc;

    /**
     * 粉尘备注
     */
    @Column(name = "Remarks_FC")
    private String remarksFc;

    /**
     * 是否高毒
     */
    @Column(name = "H_toxic")
    private String hToxic;

    /**
     * 序号_高毒物品
     */
    @Column(name = "ID_HT")
    private Integer idHt;

    /**
     * 名称_高毒物品
     */
    @Column(name = "Name_CH_HT")
    private String nameChHt;

    /**
     * 别名_高毒物品
     */
    @Column(name = "Nickname_CH_HT")
    private String nicknameChHt;

    /**
     * 英文名_高毒物品
     */
    @Column(name = "Name_EN_HT")
    private String nameEnHt;

    private static final long serialVersionUID = 1L;

    /**
     * 获取总表序号
     *
     * @return ID_list - 总表序号
     */
    public Integer getIdList() {
        return idList;
    }

    /**
     * 设置总表序号
     *
     * @param idList 总表序号
     */
    public void setIdList(Integer idList) {
        this.idList = idList;
    }

    /**
     * 获取代码
     *
     * @return paramCode - 代码
     */
    public String getParamcode() {
        return paramcode;
    }

    /**
     * 设置代码
     *
     * @param paramcode 代码
     */
    public void setParamcode(String paramcode) {
        this.paramcode = paramcode == null ? null : paramcode.trim();
    }

    /**
     * 获取名称_分类目录
     *
     * @return Name_CH - 名称_分类目录
     */
    public String getNameCh() {
        return nameCh;
    }

    /**
     * 设置名称_分类目录
     *
     * @param nameCh 名称_分类目录
     */
    public void setNameCh(String nameCh) {
        this.nameCh = nameCh == null ? null : nameCh.trim();
    }

    /**
     * 获取CAS号
     *
     * @return CASNo - CAS号
     */
    public String getCasno() {
        return casno;
    }

    /**
     * 设置CAS号
     *
     * @param casno CAS号
     */
    public void setCasno(String casno) {
        this.casno = casno == null ? null : casno.trim();
    }

    /**
     * 获取CAS号备注
     *
     * @return Remarks_CASNo - CAS号备注
     */
    public String getRemarksCasno() {
        return remarksCasno;
    }

    /**
     * 设置CAS号备注
     *
     * @param remarksCasno CAS号备注
     */
    public void setRemarksCasno(String remarksCasno) {
        this.remarksCasno = remarksCasno == null ? null : remarksCasno.trim();
    }

    /**
     * 获取序号_分类目录
     *
     * @return ID_catalogue - 序号_分类目录
     */
    public String getIdCatalogue() {
        return idCatalogue;
    }

    /**
     * 设置序号_分类目录
     *
     * @param idCatalogue 序号_分类目录
     */
    public void setIdCatalogue(String idCatalogue) {
        this.idCatalogue = idCatalogue == null ? null : idCatalogue.trim();
    }

    /**
     * 获取序号_GBZ2.1粉尘
     *
     * @return ID_FC - 序号_GBZ2.1粉尘
     */
    public Integer getIdFc() {
        return idFc;
    }

    /**
     * 设置序号_GBZ2.1粉尘
     *
     * @param idFc 序号_GBZ2.1粉尘
     */
    public void setIdFc(Integer idFc) {
        this.idFc = idFc;
    }

    /**
     * 获取中文名_粉尘
     *
     * @return Name_CH_FC - 中文名_粉尘
     */
    public String getNameChFc() {
        return nameChFc;
    }

    /**
     * 设置中文名_粉尘
     *
     * @param nameChFc 中文名_粉尘
     */
    public void setNameChFc(String nameChFc) {
        this.nameChFc = nameChFc == null ? null : nameChFc.trim();
    }

    /**
     * 获取英文名_粉尘
     *
     * @return Name_EN_FC - 英文名_粉尘
     */
    public String getNameEnFc() {
        return nameEnFc;
    }

    /**
     * 设置英文名_粉尘
     *
     * @param nameEnFc 英文名_粉尘
     */
    public void setNameEnFc(String nameEnFc) {
        this.nameEnFc = nameEnFc == null ? null : nameEnFc.trim();
    }

    /**
     * 获取PC-TWA总尘(mg/m3)
     *
     * @return PC_TWA_Total_dust - PC-TWA总尘(mg/m3)
     */
    public Float getPcTwaTotalDust() {
        return pcTwaTotalDust;
    }

    /**
     * 设置PC-TWA总尘(mg/m3)
     *
     * @param pcTwaTotalDust PC-TWA总尘(mg/m3)
     */
    public void setPcTwaTotalDust(Float pcTwaTotalDust) {
        this.pcTwaTotalDust = pcTwaTotalDust;
    }

    /**
     * 获取PC-TWA呼尘(mg/m3)
     *
     * @return PC_TWA_Respirable_dust - PC-TWA呼尘(mg/m3)
     */
    public Float getPcTwaRespirableDust() {
        return pcTwaRespirableDust;
    }

    /**
     * 设置PC-TWA呼尘(mg/m3)
     *
     * @param pcTwaRespirableDust PC-TWA呼尘(mg/m3)
     */
    public void setPcTwaRespirableDust(Float pcTwaRespirableDust) {
        this.pcTwaRespirableDust = pcTwaRespirableDust;
    }

    /**
     * 获取最大超限倍数_粉尘
     *
     * @return Max_excursion_limit_FC - 最大超限倍数_粉尘
     */
    public Float getMaxExcursionLimitFc() {
        return maxExcursionLimitFc;
    }

    /**
     * 设置最大超限倍数_粉尘
     *
     * @param maxExcursionLimitFc 最大超限倍数_粉尘
     */
    public void setMaxExcursionLimitFc(Float maxExcursionLimitFc) {
        this.maxExcursionLimitFc = maxExcursionLimitFc;
    }

    /**
     * 获取粉尘备注
     *
     * @return Remarks_FC - 粉尘备注
     */
    public String getRemarksFc() {
        return remarksFc;
    }

    /**
     * 设置粉尘备注
     *
     * @param remarksFc 粉尘备注
     */
    public void setRemarksFc(String remarksFc) {
        this.remarksFc = remarksFc == null ? null : remarksFc.trim();
    }

    /**
     * 获取是否高毒
     *
     * @return H_toxic - 是否高毒
     */
    public String gethToxic() {
        return hToxic;
    }

    /**
     * 设置是否高毒
     *
     * @param hToxic 是否高毒
     */
    public void sethToxic(String hToxic) {
        this.hToxic = hToxic == null ? null : hToxic.trim();
    }

    /**
     * 获取序号_高毒物品
     *
     * @return ID_HT - 序号_高毒物品
     */
    public Integer getIdHt() {
        return idHt;
    }

    /**
     * 设置序号_高毒物品
     *
     * @param idHt 序号_高毒物品
     */
    public void setIdHt(Integer idHt) {
        this.idHt = idHt;
    }

    /**
     * 获取名称_高毒物品
     *
     * @return Name_CH_HT - 名称_高毒物品
     */
    public String getNameChHt() {
        return nameChHt;
    }

    /**
     * 设置名称_高毒物品
     *
     * @param nameChHt 名称_高毒物品
     */
    public void setNameChHt(String nameChHt) {
        this.nameChHt = nameChHt == null ? null : nameChHt.trim();
    }

    /**
     * 获取别名_高毒物品
     *
     * @return Nickname_CH_HT - 别名_高毒物品
     */
    public String getNicknameChHt() {
        return nicknameChHt;
    }

    /**
     * 设置别名_高毒物品
     *
     * @param nicknameChHt 别名_高毒物品
     */
    public void setNicknameChHt(String nicknameChHt) {
        this.nicknameChHt = nicknameChHt == null ? null : nicknameChHt.trim();
    }

    /**
     * 获取英文名_高毒物品
     *
     * @return Name_EN_HT - 英文名_高毒物品
     */
    public String getNameEnHt() {
        return nameEnHt;
    }

    /**
     * 设置英文名_高毒物品
     *
     * @param nameEnHt 英文名_高毒物品
     */
    public void setNameEnHt(String nameEnHt) {
        this.nameEnHt = nameEnHt == null ? null : nameEnHt.trim();
    }
}