package cn.smarthse.modules.health.entity.standard;

import java.io.Serializable;
import javax.persistence.*;

@Table(name = "l_08_2_occupational_risk_factors_hx_sw")
public class L082OccupationalRiskFactorsHxSw implements Serializable {
    /**
     * 总表序号
     */
    @Id
    @Column(name = "ID_list")
    @GeneratedValue(strategy = GenerationType.IDENTITY, generator = "select RIGHT(uuid_short(), 19)")
    private Integer idList;

    /**
     * 代码
     */
    @Column(name = "paramCode")
    private String paramcode;

    /**
     * 名称_分类目录
     */
    @Column(name = "Name_CH")
    private String nameCh;

    /**
     * CAS号
     */
    @Column(name = "CASNo")
    private String casno;

    /**
     * CAS号备注
     */
    @Column(name = "Remarks_CASNo")
    private String remarksCasno;

    /**
     * 序号_分类目录
     */
    @Column(name = "ID_catalogue")
    private String idCatalogue;

    /**
     * 序号_GBZ2.1化学因素
     */
    @Column(name = "ID_HX")
    private Integer idHx;

    /**
     * 中文名
     */
    @Column(name = "Name_CH_HX")
    private String nameChHx;

    /**
     * 英文名
     */
    @Column(name = "Name_EN_HX")
    private String nameEnHx;

    /**
     * MAC(mg/m3)
     */
    @Column(name = "MAC")
    private Float mac;

    /**
     * PC-TWA(mg/m3)
     */
    @Column(name = "PC_TWA")
    private Float pcTwa;

    /**
     * PC-STEL(mg/m3)
     */
    @Column(name = "PC_STEL")
    private Float pcStel;

    /**
     * 最大超限倍数
     */
    @Column(name = "Max_excursion_limit")
    private Float maxExcursionLimit;

    /**
     * 标识备注
     */
    @Column(name = "Remarks_IARC")
    private String remarksIarc;

    /**
     * 是否高毒
     */
    @Column(name = "H_toxic")
    private String hToxic;

    /**
     * 序号_高毒物品
     */
    @Column(name = "ID_HT")
    private Integer idHt;

    /**
     * 名称_高毒物品
     */
    @Column(name = "Name_CH_HT")
    private String nameChHt;

    /**
     * 别名_高毒物品
     */
    @Column(name = "Nickname_CH_HT")
    private String nicknameChHt;

    /**
     * 英文名_高毒物品
     */
    @Column(name = "Name_EN_HT")
    private String nameEnHt;

    private static final long serialVersionUID = 1L;

    /**
     * 获取总表序号
     *
     * @return ID_list - 总表序号
     */
    public Integer getIdList() {
        return idList;
    }

    /**
     * 设置总表序号
     *
     * @param idList 总表序号
     */
    public void setIdList(Integer idList) {
        this.idList = idList;
    }

    /**
     * 获取代码
     *
     * @return paramCode - 代码
     */
    public String getParamcode() {
        return paramcode;
    }

    /**
     * 设置代码
     *
     * @param paramcode 代码
     */
    public void setParamcode(String paramcode) {
        this.paramcode = paramcode == null ? null : paramcode.trim();
    }

    /**
     * 获取名称_分类目录
     *
     * @return Name_CH - 名称_分类目录
     */
    public String getNameCh() {
        return nameCh;
    }

    /**
     * 设置名称_分类目录
     *
     * @param nameCh 名称_分类目录
     */
    public void setNameCh(String nameCh) {
        this.nameCh = nameCh == null ? null : nameCh.trim();
    }

    /**
     * 获取CAS号
     *
     * @return CASNo - CAS号
     */
    public String getCasno() {
        return casno;
    }

    /**
     * 设置CAS号
     *
     * @param casno CAS号
     */
    public void setCasno(String casno) {
        this.casno = casno == null ? null : casno.trim();
    }

    /**
     * 获取CAS号备注
     *
     * @return Remarks_CASNo - CAS号备注
     */
    public String getRemarksCasno() {
        return remarksCasno;
    }

    /**
     * 设置CAS号备注
     *
     * @param remarksCasno CAS号备注
     */
    public void setRemarksCasno(String remarksCasno) {
        this.remarksCasno = remarksCasno == null ? null : remarksCasno.trim();
    }

    /**
     * 获取序号_分类目录
     *
     * @return ID_catalogue - 序号_分类目录
     */
    public String getIdCatalogue() {
        return idCatalogue;
    }

    /**
     * 设置序号_分类目录
     *
     * @param idCatalogue 序号_分类目录
     */
    public void setIdCatalogue(String idCatalogue) {
        this.idCatalogue = idCatalogue == null ? null : idCatalogue.trim();
    }

    /**
     * 获取序号_GBZ2.1化学因素
     *
     * @return ID_HX - 序号_GBZ2.1化学因素
     */
    public Integer getIdHx() {
        return idHx;
    }

    /**
     * 设置序号_GBZ2.1化学因素
     *
     * @param idHx 序号_GBZ2.1化学因素
     */
    public void setIdHx(Integer idHx) {
        this.idHx = idHx;
    }

    /**
     * 获取中文名
     *
     * @return Name_CH_HX - 中文名
     */
    public String getNameChHx() {
        return nameChHx;
    }

    /**
     * 设置中文名
     *
     * @param nameChHx 中文名
     */
    public void setNameChHx(String nameChHx) {
        this.nameChHx = nameChHx == null ? null : nameChHx.trim();
    }

    /**
     * 获取英文名
     *
     * @return Name_EN_HX - 英文名
     */
    public String getNameEnHx() {
        return nameEnHx;
    }

    /**
     * 设置英文名
     *
     * @param nameEnHx 英文名
     */
    public void setNameEnHx(String nameEnHx) {
        this.nameEnHx = nameEnHx == null ? null : nameEnHx.trim();
    }

    /**
     * 获取MAC(mg/m3)
     *
     * @return MAC - MAC(mg/m3)
     */
    public Float getMac() {
        return mac;
    }

    /**
     * 设置MAC(mg/m3)
     *
     * @param mac MAC(mg/m3)
     */
    public void setMac(Float mac) {
        this.mac = mac;
    }

    /**
     * 获取PC-TWA(mg/m3)
     *
     * @return PC_TWA - PC-TWA(mg/m3)
     */
    public Float getPcTwa() {
        return pcTwa;
    }

    /**
     * 设置PC-TWA(mg/m3)
     *
     * @param pcTwa PC-TWA(mg/m3)
     */
    public void setPcTwa(Float pcTwa) {
        this.pcTwa = pcTwa;
    }

    /**
     * 获取PC-STEL(mg/m3)
     *
     * @return PC_STEL - PC-STEL(mg/m3)
     */
    public Float getPcStel() {
        return pcStel;
    }

    /**
     * 设置PC-STEL(mg/m3)
     *
     * @param pcStel PC-STEL(mg/m3)
     */
    public void setPcStel(Float pcStel) {
        this.pcStel = pcStel;
    }

    /**
     * 获取最大超限倍数
     *
     * @return Max_excursion_limit - 最大超限倍数
     */
    public Float getMaxExcursionLimit() {
        return maxExcursionLimit;
    }

    /**
     * 设置最大超限倍数
     *
     * @param maxExcursionLimit 最大超限倍数
     */
    public void setMaxExcursionLimit(Float maxExcursionLimit) {
        this.maxExcursionLimit = maxExcursionLimit;
    }

    /**
     * 获取标识备注
     *
     * @return Remarks_IARC - 标识备注
     */
    public String getRemarksIarc() {
        return remarksIarc;
    }

    /**
     * 设置标识备注
     *
     * @param remarksIarc 标识备注
     */
    public void setRemarksIarc(String remarksIarc) {
        this.remarksIarc = remarksIarc == null ? null : remarksIarc.trim();
    }

    /**
     * 获取是否高毒
     *
     * @return H_toxic - 是否高毒
     */
    public String gethToxic() {
        return hToxic;
    }

    /**
     * 设置是否高毒
     *
     * @param hToxic 是否高毒
     */
    public void sethToxic(String hToxic) {
        this.hToxic = hToxic == null ? null : hToxic.trim();
    }

    /**
     * 获取序号_高毒物品
     *
     * @return ID_HT - 序号_高毒物品
     */
    public Integer getIdHt() {
        return idHt;
    }

    /**
     * 设置序号_高毒物品
     *
     * @param idHt 序号_高毒物品
     */
    public void setIdHt(Integer idHt) {
        this.idHt = idHt;
    }

    /**
     * 获取名称_高毒物品
     *
     * @return Name_CH_HT - 名称_高毒物品
     */
    public String getNameChHt() {
        return nameChHt;
    }

    /**
     * 设置名称_高毒物品
     *
     * @param nameChHt 名称_高毒物品
     */
    public void setNameChHt(String nameChHt) {
        this.nameChHt = nameChHt == null ? null : nameChHt.trim();
    }

    /**
     * 获取别名_高毒物品
     *
     * @return Nickname_CH_HT - 别名_高毒物品
     */
    public String getNicknameChHt() {
        return nicknameChHt;
    }

    /**
     * 设置别名_高毒物品
     *
     * @param nicknameChHt 别名_高毒物品
     */
    public void setNicknameChHt(String nicknameChHt) {
        this.nicknameChHt = nicknameChHt == null ? null : nicknameChHt.trim();
    }

    /**
     * 获取英文名_高毒物品
     *
     * @return Name_EN_HT - 英文名_高毒物品
     */
    public String getNameEnHt() {
        return nameEnHt;
    }

    /**
     * 设置英文名_高毒物品
     *
     * @param nameEnHt 英文名_高毒物品
     */
    public void setNameEnHt(String nameEnHt) {
        this.nameEnHt = nameEnHt == null ? null : nameEnHt.trim();
    }
}