package cn.smarthse.modules.health.entity.standard;

import java.io.Serializable;
import javax.persistence.*;

@Table(name = "l_08_1_occupational_risk_factors_list")
public class L081OccupationalRiskFactorsList implements Serializable {
    /**
     * 总表序号
     */
    @Id
    @Column(name = "ID_list")
    @GeneratedValue(strategy = GenerationType.IDENTITY, generator = "select RIGHT(uuid_short(), 19)")
    private Integer idList;

    /**
     * 代码
     */
    @Column(name = "paramCode")
    private String paramcode;

    /**
     * 名称_分类目录
     */
    @Column(name = "Name_CH")
    private String nameCh;

    /**
     * CAS号
     */
    @Column(name = "CASNo")
    private String casno;

    /**
     * CAS号备注
     */
    @Column(name = "Remarks_CASNo")
    private String remarksCasno;

    /**
     * 是否高毒
     */
    @Column(name = "H_toxic")
    private String hToxic;

    /**
     * 序号_高毒物品
     */
    @Column(name = "ID_HT")
    private Integer idHt;

    /**
     * 序号_分类目录
     */
    @Column(name = "ID_catalogue")
    private String idCatalogue;

    /**
     * 序号_GBZ2.1化学因素
     */
    @Column(name = "ID_HX")
    private Integer idHx;

    /**
     * 序号_GBZ2.1粉尘
     */
    @Column(name = "ID_FC")
    private Integer idFc;

    /**
     * 是否含有呼尘
     */
    @Column(name = "has_Respirable_dust")
    private Integer hasRespirableDust;

    /**
     * 序号_职业健康检查因素
     */
    @Column(name = "ID_Occupational_health")
    private Integer idOccupationalHealth;

    /**
     * 职业禁忌证
     */
    @Column(name = "Occupational_contraindication")
    private String occupationalContraindication;

    /**
     * 职业病 
     */
    @Column(name = "Occupational_disease")
    private String occupationalDisease;

    /**
     * 可能导致职业禁忌证和职业病的依据
     */
    @Column(name = "Basis_Occupational_health")
    private String basisOccupationalHealth;

    @Column(name = "Warning_signs_recommend")
    private String warningSignsRecommend;

    private static final long serialVersionUID = 1L;

    /**
     * 获取总表序号
     *
     * @return ID_list - 总表序号
     */
    public Integer getIdList() {
        return idList;
    }

    /**
     * 设置总表序号
     *
     * @param idList 总表序号
     */
    public void setIdList(Integer idList) {
        this.idList = idList;
    }

    /**
     * 获取代码
     *
     * @return paramCode - 代码
     */
    public String getParamcode() {
        return paramcode;
    }

    /**
     * 设置代码
     *
     * @param paramcode 代码
     */
    public void setParamcode(String paramcode) {
        this.paramcode = paramcode == null ? null : paramcode.trim();
    }

    /**
     * 获取名称_分类目录
     *
     * @return Name_CH - 名称_分类目录
     */
    public String getNameCh() {
        return nameCh;
    }

    /**
     * 设置名称_分类目录
     *
     * @param nameCh 名称_分类目录
     */
    public void setNameCh(String nameCh) {
        this.nameCh = nameCh == null ? null : nameCh.trim();
    }

    /**
     * 获取CAS号
     *
     * @return CASNo - CAS号
     */
    public String getCasno() {
        return casno;
    }

    /**
     * 设置CAS号
     *
     * @param casno CAS号
     */
    public void setCasno(String casno) {
        this.casno = casno == null ? null : casno.trim();
    }

    /**
     * 获取CAS号备注
     *
     * @return Remarks_CASNo - CAS号备注
     */
    public String getRemarksCasno() {
        return remarksCasno;
    }

    /**
     * 设置CAS号备注
     *
     * @param remarksCasno CAS号备注
     */
    public void setRemarksCasno(String remarksCasno) {
        this.remarksCasno = remarksCasno == null ? null : remarksCasno.trim();
    }

    /**
     * 获取是否高毒
     *
     * @return H_toxic - 是否高毒
     */
    public String gethToxic() {
        return hToxic;
    }

    /**
     * 设置是否高毒
     *
     * @param hToxic 是否高毒
     */
    public void sethToxic(String hToxic) {
        this.hToxic = hToxic == null ? null : hToxic.trim();
    }

    /**
     * 获取序号_高毒物品
     *
     * @return ID_HT - 序号_高毒物品
     */
    public Integer getIdHt() {
        return idHt;
    }

    /**
     * 设置序号_高毒物品
     *
     * @param idHt 序号_高毒物品
     */
    public void setIdHt(Integer idHt) {
        this.idHt = idHt;
    }

    /**
     * 获取序号_分类目录
     *
     * @return ID_catalogue - 序号_分类目录
     */
    public String getIdCatalogue() {
        return idCatalogue;
    }

    /**
     * 设置序号_分类目录
     *
     * @param idCatalogue 序号_分类目录
     */
    public void setIdCatalogue(String idCatalogue) {
        this.idCatalogue = idCatalogue == null ? null : idCatalogue.trim();
    }

    /**
     * 获取序号_GBZ2.1化学因素
     *
     * @return ID_HX - 序号_GBZ2.1化学因素
     */
    public Integer getIdHx() {
        return idHx;
    }

    /**
     * 设置序号_GBZ2.1化学因素
     *
     * @param idHx 序号_GBZ2.1化学因素
     */
    public void setIdHx(Integer idHx) {
        this.idHx = idHx;
    }

    /**
     * 获取序号_GBZ2.1粉尘
     *
     * @return ID_FC - 序号_GBZ2.1粉尘
     */
    public Integer getIdFc() {
        return idFc;
    }

    /**
     * 设置序号_GBZ2.1粉尘
     *
     * @param idFc 序号_GBZ2.1粉尘
     */
    public void setIdFc(Integer idFc) {
        this.idFc = idFc;
    }

    /**
     * 获取是否含有呼尘
     *
     * @return has_Respirable_dust - 是否含有呼尘
     */
    public Integer getHasRespirableDust() {
        return hasRespirableDust;
    }

    /**
     * 设置是否含有呼尘
     *
     * @param hasRespirableDust 是否含有呼尘
     */
    public void setHasRespirableDust(Integer hasRespirableDust) {
        this.hasRespirableDust = hasRespirableDust;
    }

    /**
     * 获取序号_职业健康检查因素
     *
     * @return ID_Occupational_health - 序号_职业健康检查因素
     */
    public Integer getIdOccupationalHealth() {
        return idOccupationalHealth;
    }

    /**
     * 设置序号_职业健康检查因素
     *
     * @param idOccupationalHealth 序号_职业健康检查因素
     */
    public void setIdOccupationalHealth(Integer idOccupationalHealth) {
        this.idOccupationalHealth = idOccupationalHealth;
    }

    /**
     * 获取职业禁忌证
     *
     * @return Occupational_contraindication - 职业禁忌证
     */
    public String getOccupationalContraindication() {
        return occupationalContraindication;
    }

    /**
     * 设置职业禁忌证
     *
     * @param occupationalContraindication 职业禁忌证
     */
    public void setOccupationalContraindication(String occupationalContraindication) {
        this.occupationalContraindication = occupationalContraindication == null ? null : occupationalContraindication.trim();
    }

    /**
     * 获取职业病 
     *
     * @return Occupational_disease - 职业病 
     */
    public String getOccupationalDisease() {
        return occupationalDisease;
    }

    /**
     * 设置职业病 
     *
     * @param occupationalDisease 职业病 
     */
    public void setOccupationalDisease(String occupationalDisease) {
        this.occupationalDisease = occupationalDisease == null ? null : occupationalDisease.trim();
    }

    /**
     * 获取可能导致职业禁忌证和职业病的依据
     *
     * @return Basis_Occupational_health - 可能导致职业禁忌证和职业病的依据
     */
    public String getBasisOccupationalHealth() {
        return basisOccupationalHealth;
    }

    /**
     * 设置可能导致职业禁忌证和职业病的依据
     *
     * @param basisOccupationalHealth 可能导致职业禁忌证和职业病的依据
     */
    public void setBasisOccupationalHealth(String basisOccupationalHealth) {
        this.basisOccupationalHealth = basisOccupationalHealth == null ? null : basisOccupationalHealth.trim();
    }

    /**
     * @return Warning_signs_recommend
     */
    public String getWarningSignsRecommend() {
        return warningSignsRecommend;
    }

    /**
     * @param warningSignsRecommend
     */
    public void setWarningSignsRecommend(String warningSignsRecommend) {
        this.warningSignsRecommend = warningSignsRecommend == null ? null : warningSignsRecommend.trim();
    }
}