package cn.smarthse.modules.health.entity.standard;

import java.io.Serializable;
import javax.persistence.*;

@Table(name = "l_07_law_standard_3_content")
public class L07LawStandard3Content implements Serializable {
    /**
     * 序号
     */
    @Id
    @Column(name = "ID")
    @GeneratedValue(strategy = GenerationType.IDENTITY, generator = "select RIGHT(uuid_short(), 19)")
    private Integer id;

    /**
     * L_06_Law_standard_Database序号
     */
    @Column(name = "ID_law_standard")
    private Integer idLawStandard;

    @Column(name = "Content_list")
    private String contentList;

    /**
     * 富文本备注(1表示有段落，2表示需用插入图表或长篇文字，默认为0，表示只有单段文字）
     */
    @Column(name = "Remark_rich_text")
    private Byte remarkRichText;

    /**
     * 条文内容
     */
    @Column(name = "Content_text")
    private String contentText;
    
    /**
     * 是否存在下级子节点
     */
    @Transient
    private Boolean hasSubContent = false;

    private static final long serialVersionUID = 1L;

	public Boolean getHasSubContent() {
		return hasSubContent;
	}

	public void setHasSubContent(Boolean hasSubContent) {
		this.hasSubContent = hasSubContent;
	}

	/**
     * 获取序号
     *
     * @return ID - 序号
     */
    public Integer getId() {
        return id;
    }

    /**
     * 设置序号
     *
     * @param id 序号
     */
    public void setId(Integer id) {
        this.id = id;
    }

    /**
     * 获取L_06_Law_standard_Database序号
     *
     * @return ID_law_standard - L_06_Law_standard_Database序号
     */
    public Integer getIdLawStandard() {
        return idLawStandard;
    }

    /**
     * 设置L_06_Law_standard_Database序号
     *
     * @param idLawStandard L_06_Law_standard_Database序号
     */
    public void setIdLawStandard(Integer idLawStandard) {
        this.idLawStandard = idLawStandard;
    }

    /**
     * @return Content_list
     */
    public String getContentList() {
        return contentList;
    }

    /**
     * @param contentList
     */
    public void setContentList(String contentList) {
        this.contentList = contentList == null ? null : contentList.trim();
    }

    /**
     * 获取富文本备注(1表示有段落，2表示需用插入图表或长篇文字，默认为0，表示只有单段文字）
     *
     * @return Remark_rich_text - 富文本备注(1表示有段落，2表示需用插入图表或长篇文字，默认为0，表示只有单段文字）
     */
    public Byte getRemarkRichText() {
        return remarkRichText;
    }

    /**
     * 设置富文本备注(1表示有段落，2表示需用插入图表或长篇文字，默认为0，表示只有单段文字）
     *
     * @param remarkRichText 富文本备注(1表示有段落，2表示需用插入图表或长篇文字，默认为0，表示只有单段文字）
     */
    public void setRemarkRichText(Byte remarkRichText) {
        this.remarkRichText = remarkRichText;
    }

    /**
     * 获取条文内容
     *
     * @return Content_text - 条文内容
     */
    public String getContentText() {
        return contentText;
    }

    /**
     * 设置条文内容
     *
     * @param contentText 条文内容
     */
    public void setContentText(String contentText) {
        this.contentText = contentText == null ? null : contentText.trim();
    }
}