package cn.smarthse.modules.health.entity.out;

import lombok.Data;

import javax.persistence.*;
import java.io.Serializable;
import java.util.Date;

/**
 *接口日志表
 * @author denglibin
 * @date 2021-09-18
 */
@Table(name = "api_log")
public @Data class ApiLog implements Serializable {
	private static final long serialVersionUID = 3206627200492433489L;

	/**
     * ID
     */
    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY, generator = "select RIGHT(uuid_short(), 19)")
    private Long id;


    /**
     * 接口名称
     */
    private String apiName;

    /**
     * 地址
     */
    private String apiUrl;

    /**
     * 请求参数
     */
    private String requestParam;

    /**
     * 响应结果
     */
    private String response;

    /**
     * 是否有效（0-无效，1-有效）
     */
    @Column(name = "is_valid")
    private Boolean isValid;

    /**
     * 创建人
     */
    @Column(name = "create_by")
    private Long createBy;

    /**
     * 创建时间
     */
    @Column(name = "create_date")
    private Date createDate;

    /**
     * 最后修改人ID
     */
    @Column(name = "update_by")
    private Long updateBy;

    /**
     * 最后修改时间
     */
    @Column(name = "update_date")
    private Date updateDate;




}