package cn.smarthse.modules.health.entity.litearchive;

import cn.smarthse.common.util.sensitive.SensitiveInfo;
import cn.smarthse.common.util.sensitive.SensitiveType;
import cn.smarthse.modules.datacentre.model.system.SysFileModel;
import lombok.Data;
import lombok.experimental.Accessors;

import javax.persistence.*;
import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * @author xiaoyi
 * @date 2021/4/28 10:52
 * @desc 个人档案
 */
@Data
@Accessors(chain = true)
public class LiteArchiveFilePersonal implements Serializable {
    @Id
    @Column(name = "id")
    @GeneratedValue(strategy = GenerationType.IDENTITY, generator = "select RIGHT(uuid_short(), 19)")
    private Long id;

    private Long cid; //企业id

    //档案id
    @Column(name = "lite_archive_id")
    private Long liteArchiveId;


    //附件id
    @Column(name = "file_ids")
    private String fileIds;

    //人员id
    @Column(name = "staff_id")
    private Long staffId;

    //人员姓名
    @Column(name = "staff_name")
    @SensitiveInfo(type = SensitiveType.USER_NAME)
    private String staffName;


    /**
     * 是否有效（0-无效，1-有效）
     */
    @Column(name = "is_valid")
    private Boolean isValid;

    /**
     * 创建时间
     */
    @Column(name = "create_date")
    private Date createDate;

    /**
     * 创建人
     */
    @Column(name = "create_by")
    private Long createBy;

    /**
     * 最后修改时间
     */
    @Column(name = "update_date")
    private Date updateDate;

    /**
     * 最后修改人ID
     */
    @Column(name = "update_by")
    private Long updateBy;

    /**
     * 最后修改人ID
     */
    @Column(name = "doc_no")
    private String docNo;

    @Transient
    private String updateName;

    /**
     * 附件id
     */
    @Transient
    private List<Long> fileIdList;

    /**
     * 附件名
     */
    @Transient
    private List<String> fileNameList;
    @Transient
    private List<SysFileModel> fileList;//附件对象列表

    @Transient
    @SensitiveInfo(type = SensitiveType.ID_CARD)
    private  String idCard;

    @Transient
    private  Long workId;

    @Transient
    private String workName;

    @Transient
    private Integer uploadNum=0; //已上传数量

    @Transient
    private List<String> progressRateTips;


}
