package cn.smarthse.modules.health.entity.litearchive;

import lombok.Data;

import javax.persistence.Column;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import java.io.Serializable;
import java.util.Date;

/**
 * @author 邓力宾
 * @date 2021/4/27 13:45
 * @desc 档案-文件名称
 */
@Data
public class LiteArchiveFileName implements Serializable {
    private static final long serialVersionUID = 1599158411215897770L;
    @Id
    @Column(name = "id")
    @GeneratedValue(strategy = GenerationType.IDENTITY, generator = "select RIGHT(uuid_short(), 19)")
    private Long id;

    //文件名
    private String fileName;
    private String groupName;
    private String tipInfo;
    //模板下载地址
    private String templatePath;
    //档案类型 1:三同时, 5:职业健康监护管理,4:职业病危害因素监测与检测评价,2:职业卫生管理档案,3:职业卫生宣传培训档案
    private Integer archiveType;
    //排序
    private Integer sort;
    //需要统计collect
    //是否需要纳入统计， 默认0  不统计
    private Boolean needCollect;
    private Boolean needUpload;
    private Boolean hgNeedUpload;
    /**
     * 是否需要存放位置， 默认0  不统计
     */
    private Boolean needStorageLocation;

    /**
     * 存放位置
     */
    /**
     * 是否有效（0-无效，1-有效）
     */
    @Column(name = "is_valid")
    private Boolean isValid;

    /**
     * 创建时间
     */
    @Column(name = "create_date")
    private Date createDate;

    /**
     * 创建人
     */
    @Column(name = "create_by")
    private Long createBy;

    /**
     * 最后修改时间
     */
    @Column(name = "update_date")
    private Date updateDate;

    /**
     * 最后修改人ID
     */
    @Column(name = "update_by")
    private Long updateBy;
}
