package cn.smarthse.modules.health.entity.litearchive;

import cn.smarthse.modules.datacentre.model.system.SysFileModel;
import lombok.Data;

import javax.persistence.*;
import java.io.Serializable;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;

/**
 * lite_archive_file_item_child
 * @author 
 */
@Table(name="lite_archive_file_item_child")
@Data
public class LiteArchiveFileItemChild implements Serializable {
    /**
     * 键值uuid_short
     */
    @Id
    @Column(name = "id")
    @GeneratedValue(strategy = GenerationType.IDENTITY, generator = "select RIGHT(uuid_short(), 19)")
    private Long id;

    /**
     * 年度
     */
    private String year;

    /**
     * lite_archive_file_item附件表id
     */
    @Column(name = "item_id")
    private Long itemId;

    /**
     * 上传人
     */
    @Column(name = "upload_staff_id")
    private String uploadStaffId;

    /**
     * 附件ids
     */
    @Column(name = "file_ids")
    private String fileIds;

    /**
     * 系统自动生成文档显示在参考资料处
     */
    @Column(name = "refer_file_ids")
    private String referFileIds;

    /**
     * 上传时间
     */
    @Column(name = "upload_date")
    private Date uploadDate;

    /**
     * 是否有效（0-无效，1-有效）
     */
    @Column(name = "is_valid")
    private Boolean isValid;

    /**
     * 创建时间
     */
    @Column(name = "create_date")
    private Date createDate;

    /**
     * 创建人
     */
    @Column(name = "create_by")
    private Long createBy;

    /**
     * 最后修改时间
     */
    @Column(name = "update_date")
    private Date updateDate;

    /**
     * 最后修改人ID
     */
    @Column(name = "update_by")
    private Long updateBy;

    @Transient
    private String uploadStaffName;

    @Transient
    private Long fileNameId;

    private static final long serialVersionUID = 1L;

    @Transient
    private List<SysFileModel> fileList = new LinkedList<>();//附件对象列表


}