package cn.smarthse.modules.health.entity.litearchive;

import lombok.Data;
import lombok.experimental.Accessors;

import javax.persistence.*;
import java.io.Serializable;
import java.util.Date;

/**
 * @author 邓力宾
 * @date 2021/4/27 13:52
 * @desc 档案-文件名称-附件
 */
@Data
@Accessors(chain = true)
public class LiteArchiveFileItem implements Serializable {
    @Id
    @Column(name = "id")
    private Long id;
    @Transient
    private Long cid;

    //档案id
    private Long liteArchiveId;

    //档案文件名id
    private Long fileNameId;

    //附件id
    private String fileIds;

    //上传人id
    private Long uploadStaffId;

    //上传时间
    private Date uploadDate;

    /**
     * 数据状态， 1完整， 0未完整
     */
    private Integer dataState;
    private Integer hgDataState;
    /**
     * 1 需上传附件， 2数据完整， 4需上传附件以及数据完整，   8
     */
    private Integer isRequired;
    /**
     * 1 需上传附件， 2数据完整， 4需上传附件以及数据完整，   8
     */
    private Integer hgIsRequired;


    /**
     * 数据状态， 完整与不完整的情况 跳转地址（情况不一样地址也不一样）
     */
    private String jumpUrl;

    /**
     * 参考资料
     */
    private String referFileIds;
    /**
     * 存放位置
     */
    private String storageLocation;
    /**
     * 是否有效（0-无效，1-有效）
     */
    @Column(name = "is_valid")
    private Boolean isValid;

    /**
     * 创建时间
     */
    @Column(name = "create_date")
    private Date createDate;

    /**
     * 创建人
     */
    @Column(name = "create_by")
    private Long createBy;

    /**
     * 最后修改时间
     */
    @Column(name = "update_date")
    private Date updateDate;

    /**
     * 最后修改人ID
     */
    @Column(name = "update_by")
    private Long updateBy;
}
