package cn.smarthse.modules.health.entity.litearchive;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.persistence.*;
import java.io.Serializable;
import java.util.Date;

/**
 * @author 邓力宾
 * @date 2021/4/27 13:49
 * @desc 档案
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
public class LiteArchive implements Serializable {

    private static final long serialVersionUID = -8002167699983293272L;

    @Id
    @Column(name = "id")
    @GeneratedValue(strategy = GenerationType.IDENTITY, generator = "select RIGHT(uuid_short(), 19)")
    private Long id;
    //企业id
    private Long cid;
    //档案类型 1:三同时, 5:职业健康监护管理,4:职业病危害因素监测与检测评价,2:职业卫生管理档案,3:职业卫生宣传培训档案 6:劳动者
    private Integer archiveType;
    //标题
    private String title;
    //状态 1：未上传 2：未完善 3：已完善 4:项目未竣工
    private Integer status;
    private Integer hgStatus;
    //档案处理状态：1生成中
    private Integer procStatus;
    //是否自动添加（三同时）
    private Boolean autoAdd;
    //档案更新时间
    private Date archiveUpdateTime;
    /**
     * 是否有效（0-无效，1-有效）
     */
    @Column(name = "is_valid")
    private Boolean isValid;
    @Column(name = "update_version")
    private Integer updateVersion;
    /**
     * 创建时间
     */
    @Column(name = "create_date")
    private Date createDate;
    /**
     * 创建人
     */
    @Column(name = "create_by")
    private Long createBy;
    /**
     * 最后修改时间
     */
    @Column(name = "update_date")
    private Date updateDate;
    /**
     * 最后修改人ID
     */
    @Column(name = "update_by")
    private Long updateBy;
    @Column(name = "extra_json")
    private String extraJson;

    public LiteArchive(Boolean isValid, Integer archiveType, Long cid, String title) {
        this.isValid = isValid;
        this.archiveType = archiveType;
        this.cid = cid;
        this.title = title;
    }
}
