package cn.smarthse.modules.health.entity.information;



import lombok.Data;

import javax.persistence.*;
import java.io.Serializable;
import java.util.Date;


/**
 * <p>
 * 讯息表
 * </p>
 *
 * @author 邓力宾
 * @since 2022-02-15
 */
@Data
public class Information implements Serializable {

    private static final long serialVersionUID = 1L;

    @Id
    @Column(name = "id")
    @GeneratedValue(strategy = GenerationType.IDENTITY, generator = "select uuid_short()")
    //(value = "id主键")
    private Long id;

    //(value = "企业id")
    private Long cid;

    //(value = "类型（1：政策速递与解读 2：通知公告 3：科普知识）")
    private Integer type;

    //(value = "科普知识类别id")
    private Long scienceTypeId;

    @Transient
    private String scienceTypeName;

    @Transient
    private String surfaceImgUrl;

    //(value = "标题")
    private String title;

    //(value = "是否置顶")
    private Boolean isTop;

    //(value = "点击量")
    private Integer clickNum;

    //(value = "维护人")
    private String maintainName;

    //(value = "状态,1:草稿, 2:下架 3：上架")
    private Integer status;

    //(value = "上架时间")
    private Date onTime;

    //(value = "来源")
    private String source;

    //(value = "作者")
    private String author;

    //(value = "封面图片id")
    private Long surfaceImgId;

    //(value = "摘要")
    private String digest;

    //(value = "文本id")
    private Long textId;

    //(value = "创建时间")
    private Date createDate;

    //(value = "创建人")
    private Long createBy;

    //(value = "最后修改时间")
    private Date updateDate;

    //(value = "最后修改人ID")
    private Long updateBy;

    //(value = "是否有效（0-无效，1-有效）")
    private Boolean isValid;


}
