package cn.smarthse.modules.health.entity.information;

import lombok.Data;

import javax.persistence.Column;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import java.io.Serializable;
import java.util.Date;

/**
 * <p>
 * 科普知识类别
 * </p>
 *
 * @author 邓力宾
 * @since 2022-02-15
 */
@Data
public class InfoScienceType implements Serializable {

    private static final long serialVersionUID = 1L;
    @Id
    @Column(name = "id")
    @GeneratedValue(strategy = GenerationType.IDENTITY, generator = "select uuid_short()")
    //(value = "id主键")
    private Long id;

    //(value = "类别名称")
    private String name;

    //(value = "父id")
    private Long pid;

    //(value = "创建时间")
    private Date createDate;

    //(value = "创建人")
    private Long createBy;

    //(value = "最后修改时间")
    private Date updateDate;

    //(value = "最后修改人ID")
    private Long updateBy;

    //(value = "是否有效（0-无效，1-有效）")
    private Boolean isValid;


}
