package cn.smarthse.modules.health.entity.information;


import java.io.Serializable;
import java.util.Date;

import lombok.Data;

import javax.persistence.Column;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;


/**
 * <p>
 * 应用资源
 * </p>
 *
 * @author 邓力宾
 * @since 2022-02-15
 */
@Data
public class AppResource implements Serializable {

    private static final long serialVersionUID = 1L;
    @Id
    @Column(name = "id")
    @GeneratedValue(strategy = GenerationType.IDENTITY, generator = "select uuid_short()")
    //(value = "id主键")
    private Long id;

    //(value = "企业id")
    private Long cid;

    //(value = "类型（1：法规标准 2：职业病危害信息 3：管理工具 4：其他）")
    private Integer type;

    //(value = "网站名称")
    private String title;

    //(value = "链接")
    private String url;

    //(value = "状态 1：未发布 2：已发布")
    private Integer status;

    //(value = "排序号")
    private Integer sort;

    //(value = "创建时间")
    private Date createDate;

    //(value = "创建人")
    private Long createBy;

    //(value = "最后修改时间")
    private Date updateDate;

    //(value = "最后修改人ID")
    private Long updateBy;

    //(value = "是否有效（0-无效，1-有效）")
    private Boolean isValid;


}
