package cn.smarthse.modules.health.entity.datascope;

import cn.smarthse.modules.health.enums.datascope.DataScopeEnum;
import lombok.Data;

import java.util.List;

/**
 * @author zhoulj(周利军) [1217102780@qq.com]
 * @Title: DataScopeEntity
 * @Project: ${MODEL_NAME}
 * @Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * @Comments: <对此类的描述，可以引用系统设计中的描述>
 * @JDK version used:      <JDK1.8> 17
 * @since 2019/10/9-11:17
 */
public @Data class DataScope {


    /**
     * 用户所有下属 部门集合（后期考虑有编码方式， 这里会比较耗性能）
     */
    private List<Long> orgIdList;


    /**
     * 登录用户id
     */
    private String loginStaffId;

    /**
     * 数据权限主表名（DB.XX_TABLE 非java中的实体）
     */
    private String mainTableName;

    /**
     * 主查询中 部门的列名
     */
    private String orgColumnAlias;
    private String modelName;


    /**
     * 登录人所属组织机构
     */
    private String orgId;
    /**
     * 特殊SQL 需要 排序无法解析的情况
     */
    private String orderByStr = "";

    /**
     * 针对像人员模块的数据权限， 权限已经在业务表的  staff.id
     */
    private String createBy = "";
}
