package cn.smarthse.modules.health.entity.base.workinfo;

import cn.smarthse.modules.datacentre.model.system.riskFactors.HarmFactor;
import cn.smarthse.modules.health.entity.base.occriskfactor.OccupationalRiskFactors;
import cn.smarthse.modules.health.entity.work.shield.ProtectList;

import javax.persistence.*;
import java.io.Serializable;
import java.util.Date;
import java.util.List;


@Table(name = "work_role_info")
public class WorkRoleInfo implements Serializable {
    /**
     * ID
     */
    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY, generator = "select RIGHT(uuid_short(), 19)")
    private Long id;

    /**
     * 企业ID
     */
    private Long cid;

    /**
     * 岗位/工种名称
     */
    @Column(name = "work_name")
    private String workName;
    
    
    @Column(name="org_id")
    private Long orgId;
    
    @Transient
    private String orgName;
    
    /**
     * 工作场所
     */
    @Transient
	private List<WorkAreaInfo>  workAreaInfos;
    
    /**
     * 工作场所名称
     */
    @Transient
    private String workAreaInfoNames;
    /**
     * 序号
     */
    @Transient
    private int serial;
    @Transient
    private String idStr;
    /**
     * 人数
     */
    @Transient
    private Integer staffNum;
    /**
     * 本企业人员数
     */
    @Transient
    private Integer selfstaffNum;
    /**
     * 外包人员数
     */
    @Transient
    private Integer thirdstaffNum;

    /**
     * 女工人员数
     */
    @Transient
    private Integer femaleStaffNum;


    /**
     * 是否有效（0-无效，1-有效）
     */
    @Column(name = "is_valid")
    private Boolean isValid;


    /**
     * 存在危害因素ids
     *
     */
    @Transient
    private Boolean orgIsValid;
    /**
     * 创建人
     */
    @Column(name = "create_by")
    private Long createBy;

    /**
     * 创建时间
     */
    @Column(name = "create_date")
    private Date createDate;

    /**
     * 最后修改人ID
     */
    @Column(name = "update_by")
    private Long updateBy;

    /**
     * 最后修改时间
     */
    @Column(name = "update_date")
    private Date updateDate;
    /**
     * 接触职业病危害因素id多个用,分隔
     */
    @Column(name = "harm_fanctor_ids")
    private String harmFanctorIds;


    /**
     * 数据来源（1 万达仓)
     */
    @Column(name = "data_source")
    private Byte dataSource;

    /**
     * 数据修改来源（1 万达仓)
     */
    @Column(name = "data_update_source")
    private Byte dataUpdateSource;

    @Column(name = "protect_ids")
    private String protectIds;

    //危害因素列表
    @Transient
    private List<HarmFactor> harmFactorList;
    //防护用品列表
    @Transient
    private List<ProtectList> protectList;

    public List<HarmFactor> getHarmFactorList() {
        return harmFactorList;
    }

    public void setHarmFactorList(List<HarmFactor> harmFactorList) {
        this.harmFactorList = harmFactorList;
    }

    public List<ProtectList> getProtectList() {
        return protectList;
    }

    public void setProtectList(List<ProtectList> protectList) {
        this.protectList = protectList;
    }

    public String getProtectIds() {
        return protectIds;
    }

    public void setProtectIds(String protectIds) {
        this.protectIds = protectIds;
    }

    /**
     * 存在危害因素ids
     *
     */
    @Transient
    private String harmIds;
    /**
     * 存在危害因素
     */
    @Transient
    private String riskFactorNames;

    /**
     * 防护用品
     */
    @Transient
    private String protectiveEquipments;

    /**
     * 是否是新增
     */
    @Transient
    private Boolean newAdd;

    List<OccupationalRiskFactors> factors;

    private static final long serialVersionUID = 1L;

    /**
     * 获取ID
     *
     * @return id - ID
     */
    public Long getId() {
        return id;
    }

    /**
     * 设置ID
     *
     * @param id ID
     */
    public void setId(Long id) {
        this.id = id;
    }

    /**
     * 获取企业ID
     *
     * @return cid - 企业ID
     */
    public Long getCid() {
        return cid;
    }

    /**
     * 设置企业ID
     *
     * @param cid 企业ID
     */
    public void setCid(Long cid) {
        this.cid = cid;
    }

    /**
     * 获取岗位/工种名称
     *
     * @return work_name - 岗位/工种名称
     */
    public String getWorkName() {
        return workName;
    }

    /**
     * 设置岗位/工种名称
     *
     * @param workName 岗位/工种名称
     */
    public void setWorkName(String workName) {
        this.workName = workName == null ? null : workName.trim();
    }

    /**
     * 获取是否有效（0-无效，1-有效）
     *
     * @return is_valid - 是否有效（0-无效，1-有效）
     */
    public Boolean getIsValid() {
        return isValid;
    }

    /**
     * 设置是否有效（0-无效，1-有效）
     *
     * @param isValid 是否有效（0-无效，1-有效）
     */
    public void setIsValid(Boolean isValid) {
        this.isValid = isValid;
    }

    /**
     * 获取创建人
     *
     * @return create_by - 创建人
     */
    public Long getCreateBy() {
        return createBy;
    }

    /**
     * 设置创建人
     *
     * @param createBy 创建人
     */
    public void setCreateBy(Long createBy) {
        this.createBy = createBy;
    }

    /**
     * 获取创建时间
     *
     * @return create_date - 创建时间
     */
    public Date getCreateDate() {
        return createDate;
    }

    /**
     * 设置创建时间
     *
     * @param createDate 创建时间
     */
    public void setCreateDate(Date createDate) {
        this.createDate = createDate;
    }

    /**
     * 获取最后修改人ID
     *
     * @return update_by - 最后修改人ID
     */
    public Long getUpdateBy() {
        return updateBy;
    }

    /**
     * 设置最后修改人ID
     *
     * @param updateBy 最后修改人ID
     */
    public void setUpdateBy(Long updateBy) {
        this.updateBy = updateBy;
    }

    /**
     * 获取最后修改时间
     *
     * @return update_date - 最后修改时间
     */
    public Date getUpdateDate() {
        return updateDate;
    }

    /**
     * 设置最后修改时间
     *
     * @param updateDate 最后修改时间
     */
    public void setUpdateDate(Date updateDate) {
        this.updateDate = updateDate;
    }

	public Long getOrgId() {
		return orgId;
	}

	public void setOrgId(Long orgId) {
		this.orgId = orgId;
	}

	public String getOrgName() {
		return orgName;
	}

	public void setOrgName(String orgName) {
		this.orgName = orgName;
	}

	public String getWorkAreaInfoNames() {
		return workAreaInfoNames;
	}

	public void setWorkAreaInfoNames(String workAreaInfoNames) {
		this.workAreaInfoNames = workAreaInfoNames;
	}

	public List<WorkAreaInfo> getWorkAreaInfos() {
		return workAreaInfos;
	}

	public void setWorkAreaInfos(List<WorkAreaInfo> workAreaInfos) {
		this.workAreaInfos = workAreaInfos;
	}

    public int getSerial() {
        return serial;
    }

    public void setSerial(int serial) {
        this.serial = serial;
    }

    public Integer getStaffNum() {
        return staffNum;
    }

    public Integer getThirdstaffNum() {
        return thirdstaffNum;
    }

    public void setThirdstaffNum(Integer thirdstaffNum) {
        this.thirdstaffNum = thirdstaffNum;
    }

    public void setStaffNum(Integer staffNum) {
        this.staffNum = staffNum;
    }

    public Integer getSelfstaffNum() {
        return selfstaffNum;
    }

    public void setSelfstaffNum(Integer selfstaffNum) {
        this.selfstaffNum = selfstaffNum;
    }

    public String getRiskFactorNames() {
        return riskFactorNames;
    }

    public void setRiskFactorNames(String riskFactorNames) {
        this.riskFactorNames = riskFactorNames;
    }

    public String getProtectiveEquipments() {
        return protectiveEquipments;
    }

    public void setProtectiveEquipments(String protectiveEquipments) {
        this.protectiveEquipments = protectiveEquipments;
    }

    public List<OccupationalRiskFactors> getFactors() {
        return factors;
    }

    public void setFactors(List<OccupationalRiskFactors> factors) {
        this.factors = factors;
    }

    public String getHarmIds() {
        return harmIds;
    }

    public void setHarmIds(String harmIds) {
        this.harmIds = harmIds;
    }

    public String getHarmFanctorIds() {
        return harmFanctorIds;
    }

    public void setHarmFanctorIds(String harmFanctorIds) {
        this.harmFanctorIds = harmFanctorIds;
    }

    public Integer getFemaleStaffNum() {
        return femaleStaffNum;
    }

    public void setFemaleStaffNum(Integer femaleStaffNum) {
        this.femaleStaffNum = femaleStaffNum;
    }

    public Boolean getOrgIsValid() {
        return orgIsValid;
    }

    public void setOrgIsValid(Boolean orgIsValid) {
        this.orgIsValid = orgIsValid;
    }

    public String getIdStr() {
        return idStr;
    }

    public void setIdStr(String idStr) {
        this.idStr = idStr;
    }

    public Boolean getNewAdd() {
        return newAdd;
    }

    public void setNewAdd(Boolean newAdd) {
        this.newAdd = newAdd;
    }

    public Byte getDataSource() {
        return dataSource;
    }

    public void setDataSource(Byte dataSource) {
        this.dataSource = dataSource;
    }

    public Byte getDataUpdateSource() {
        return dataUpdateSource;
    }

    public void setDataUpdateSource(Byte dataUpdateSource) {
        this.dataUpdateSource = dataUpdateSource;
    }
}