package cn.smarthse.modules.health.entity.base.wmbase;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

import javax.persistence.*;

import cn.smarthse.common.util.DateUtils;

@Table(name = "wm_maintenance_detail")
public class WmMaintenanceDetail implements Serializable {
    /**
     * 自动编号
     */
    @Id
    @Column(name = "id")
    @GeneratedValue(strategy = GenerationType.IDENTITY, generator = "select RIGHT(uuid_short(), 19)")
    private Long id;

    /**
     * 企业id
     */
    private Long cid;

    /**
     * 1-正常,0-已删除
     */
    @Column(name = "is_valid")
    private Boolean isValid;

    /**
     * 最后修改时间
     */
    @Column(name = "update_date")
    private Date updateDate;

    /**
     * 最后修改人
     */
    @Column(name = "update_by")
    private Long updateBy;

    /**
     * 创建人
     */
    @Column(name = "create_by")
    private Long createBy;

    /**
     * 创建时间
     */
    @Column(name = "create_date")
    private Date createDate;

    /**
     * 工作名称
     */
    @Column(name = "mainte_reason")
    private String mainteReason;

    /**
     * 备注
     */
    @Column(name = "remark")
    private String remark;

    /**
     * 负责人
     */
    @Column(name = "contact_id")
    private Long contactId;

    /**
     * 检修时间
     */
    @Column(name = "mainte_time")
    private Date mainteTime;

    /**
     * 维护说明
     */
    @Column(name = "main_content")
    private String mainContent;
    
    /**
     * 保存状态(0存草稿1完成)
     */
    @Column(name = "save_state")
    private Boolean saveState;
    /**
     * 组织部门
     */
    @Column(name = "org_id")
    private String orgId;
   
    /**
     * 维护区域
     */
    @Transient
    private String concatArea;
    
    
    /**
     * 负责人姓名
     */
    @Transient
    private String contactName;
    
    /**
     * 序号
     */
    @Transient
    private Integer serialNum;
    
    
    /**
     * 排序
     */
    @Transient
    private String order;
 
    @Transient
    private List<WmMaintenanceDetailArea> areaList;
    private static final long serialVersionUID = 1L;

    
    @Transient
    private String time;
    
    
    
    public String getTime() {
    	this.setTime(time);
		return time;
	}

	public void setTime(String time) {
		if(this.mainteTime != null){
			this.time = DateUtils.formatDate(this.mainteTime);
		}
	}

	public String getOrder() {
		return order;
	}

	public void setOrder(String order) {
		this.order = order;
	}

	public String getConcatArea() {
		return concatArea;
	}

	public void setConcatArea(String concatArea) {
		this.concatArea = concatArea;
	}

	public String getContactName() {
		return contactName;
	}

	public void setContactName(String contactName) {
		this.contactName = contactName;
	}

	public Boolean getSaveState() {
		return saveState;
	}

	public void setSaveState(Boolean saveState) {
		this.saveState = saveState;
	}

	/**
     * 获取自动编号
     *
     * @return ID - 自动编号
     */
    public Long getId() {
        return id;
    }

    /**
     * 设置自动编号
     *
     * @param id 自动编号
     */
    public void setId(Long id) {
        this.id = id;
    }

    /**
     * 获取企业id
     *
     * @return cid - 企业id
     */
    public Long getCid() {
        return cid;
    }

    /**
     * 设置企业id
     *
     * @param cid 企业id
     */
    public void setCid(Long cid) {
        this.cid = cid;
    }

    /**
     * 获取1-正常,0-已删除
     *
     * @return is_valid - 1-正常,0-已删除
     */
    public Boolean getIsValid() {
        return isValid;
    }

    /**
     * 设置1-正常,0-已删除
     *
     * @param isValid 1-正常,0-已删除
     */
    public void setIsValid(Boolean isValid) {
        this.isValid = isValid;
    }

    /**
     * 获取最后修改时间
     *
     * @return update_date - 最后修改时间
     */
    public Date getUpdateDate() {
        return updateDate;
    }

    /**
     * 设置最后修改时间
     *
     * @param updateDate 最后修改时间
     */
    public void setUpdateDate(Date updateDate) {
        this.updateDate = updateDate;
    }

    /**
     * 获取最后修改人
     *
     * @return update_by - 最后修改人
     */
    public Long getUpdateBy() {
        return updateBy;
    }

    /**
     * 设置最后修改人
     *
     * @param updateBy 最后修改人
     */
    public void setUpdateBy(Long updateBy) {
        this.updateBy = updateBy;
    }

    /**
     * 获取创建人
     *
     * @return create_by - 创建人
     */
    public Long getCreateBy() {
        return createBy;
    }

    /**
     * 设置创建人
     *
     * @param createBy 创建人
     */
    public void setCreateBy(Long createBy) {
        this.createBy = createBy;
    }

    /**
     * 获取创建时间
     *
     * @return create_date - 创建时间
     */
    public Date getCreateDate() {
        return createDate;
    }

    /**
     * 设置创建时间
     *
     * @param createDate 创建时间
     */
    public void setCreateDate(Date createDate) {
        this.createDate = createDate;
    }

    /**
     * 获取工作名称
     *
     * @return mainte_reason - 工作名称
     */
    public String getMainteReason() {
        return mainteReason;
    }

    /**
     * 设置工作名称
     *
     * @param mainteReason 工作名称
     */
    public void setMainteReason(String mainteReason) {
        this.mainteReason = mainteReason == null ? null : mainteReason.trim();
    }

    /**
     * 获取备注
     *
     * @return mainte_remark - 备注
     */
    public String getRemark() {
        return remark;
    }

    /**
     * 设置备注
     *
     * @param mainteRemark 备注
     */
    public void setRemark(String remark) {
        this.remark = remark == null ? null : remark.trim();
    }

    /**
     * 获取负责人
     *
     * @return 负责人 - 负责人
     */
    public Long getContactId() {
        return contactId;
    }

    /**
     * 设置负责人
     *
     * @param 负责人 负责人
     */
    public void setContactId(Long contactId) {
        this.contactId = contactId;
    }

    /**
     * 获取检修时间
     *
     * @return mainte_time - 检修时间
     */
    public Date getMainteTime() {
        return mainteTime;
    }

    /**
     * 设置检修时间
     *
     * @param mainteTime 检修时间
     */
    public void setMainteTime(Date mainteTime) {
        this.mainteTime = mainteTime;
    }

    /**
     * 获取维护说明
     *
     * @return main_content - 维护说明
     */
    public String getMainContent() {
        return mainContent;
    }
    
    public String getOrgId() {
		return orgId;
	}

	public void setOrgId(String orgId) {
		this.orgId = orgId;
	}

	/**
     * 设置维护说明
     *
     * @param mainContent 维护说明
     */
    public void setMainContent(String mainContent) {
        this.mainContent = mainContent == null ? null : mainContent.trim();
    }

	public List<WmMaintenanceDetailArea> getAreaList() {
		return areaList;
	}

	public void setAreaList(List<WmMaintenanceDetailArea> areaList) {
		this.areaList = areaList;
	}

	public Integer getSerialNum() {
		return serialNum;
	}

	public void setSerialNum(Integer serialNum) {
		this.serialNum = serialNum;
	}


    
}